#ifndef		TIGCPB_GAME_H
#define		TIGCPB_GAME_H

#include <allegro.h>
#include <vector>
#include "Resources.h"
#include "Settings.h"
#include "Buttons.h"

#define	MASK_INTRO		0
#define	MASK_MAINMENU		1
#define	MASK_PLAY		2
#define	MASK_CREDITS		3

class Play;

class Game
{
	private:
		Resources *resources;
		Settings settings;
		Buttons buttons;
		
		bool
			updated,
			quit_flag;
		
		// Memory bitmap(s) (for double-buffering)
		BITMAP *virt;
		
		// Game masks (intro, playing, screen transition)
		int game_mask;
		
		Play *play;
		
		// Page-flipping data (exp)
		BITMAP *page[2]; int page_num;
	protected:
		int TimerSetup(int bps);
		int VideoSetup(int colordepth, int resw, int resh, int card);
		
		void ScreenUpdate();
		void LogicalUpdate();
	public:
		Game();
		~Game();
		
		int Init();
		void Run();
		void Quit();
		
		Resources *GetResources() { return resources; }
		Buttons *GetButtons() { return &buttons; }
		Play *GetPlay() { return play; }
		
};

#endif		// TIGCPB_GAME_H