#define DEBUGMODE

#include "FlyingEnemy.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"

FlyingEnemy::FlyingEnemy(GameScreen *gs)
	:Object(gs, false),
	framecounter(0),
	framedest(0),
	current_point(0)
{
	type = OBJTYPE_FLYINGENEMY;
	health = 100;
	is_character = false;
	user_controlled = false;
	possessable = false;
	fullhealth = 1000;
	
	aexplode = new AudioSampler(GetSound());
}

void FlyingEnemy::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "flypoint"))
	{
		FLYPOINT fp;
		fp.x = ini->ReadInteger();
		fp.y = ini->ReadInteger();
		fp.interval = ini->ReadInteger();
		
		points.push_back(fp);
	}
	if (!strcmp(ini->Variable(), "animation"))
	{
		char *s = ini->ReadQString();
		anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist[s]));
		free(s);
	}
	if (!strcmp(ini->Variable(), "aexplode"))
		aexplode->LoadFromINI(ini);
}

void FlyingEnemy::ProcessAI()
{
	static int
		first, second,
		xd, yd;
	
	bool destroyed = false;
	
	if (visible)
	{
		Object *mc = gamescreen->GetPlay()->GetMainCharacter();
		if (!mc->IsDead())
			if (Intersect(mc))
			{
				destroyed = true;
				mc->Death();
			}
		
		gamescreen->CNReset();
		while(!gamescreen->CNEnd() && !destroyed)
		{
			Object *obj = gamescreen->CNGet();
			if (!obj->IsDead())
				if (Intersect(obj))
				{
					obj->Death();
					destroyed = true;
				}
			gamescreen->CNNext();
		}
	}
	
	if (destroyed)
	{
		if (IsOnScreen())
			aexplode->Play();
		Destroy();
		return;
	}
	
	if ( !current_point && !framecounter )
	{
		first = current_point;
		second = current_point+1 >= points.size() ? 0 : current_point+1;
		xpos = points[first].x << 8;
		ypos = points[first].y << 8;
		xd = (points[second].x - points[first].x << 8) / points[first].interval;
		yd = (points[second].y - points[first].y << 8) / points[first].interval;
	}	
	
	xpos += xd;
	ypos += yd;
	
	framecounter++;
	if (framecounter >= points[first].interval)
	{
		framecounter = 0;
		current_point++;
		if (current_point >= points.size())
			current_point = 0;
		
		first = current_point;
		second = current_point+1 >= points.size() ? 0 : current_point+1;
		xpos = points[first].x << 8;
		ypos = points[first].y << 8;
		xd = (points[second].x - points[first].x << 8) / points[first].interval;
		yd = (points[second].y - points[first].y << 8) / points[first].interval;		
	}
}