#include "Finch.h"
#include "GameScreen.h"

Finch::Finch(GameScreen *gs)
	:Pip(gs)
{
	type = OBJTYPE_FINCH;
}

void Finch::Init()
{
	Object::Init();
	
	LoadProperties("data\\finch.txt");
	
	health = fullhealth;
	
	if (!gamescreen) return;
	
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["finchidle"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["finchwalk"]));
	anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist["finchidle"]));
	
	SwitchToState(STATE_FALLING, 0, 0);	
}

void Finch::ProcessAI()
{
	Pip::ProcessAI();
	
	if (state == STATE_SLEEP)
		SwitchToState(STATE_WALK, 3, 1);
}