#define DEBUGMODE

#include "FallingEnemy.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"

FallingEnemy::FallingEnemy(GameScreen *gs)
	:Object(gs, false),
	y_start(0), y_end(0),
	damage(0),
	framecounter(0),
	framedest(0), yd(0),
	particles(false),
	current_interval(0)
{
	type = OBJTYPE_FALLINGENEMY;
	health = 100;
	is_character = false;
	user_controlled = false;
	possessable = false;
	fullhealth = 1000;
	
	afall = new AudioSampler(GetSound());
}

void FallingEnemy::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "yrange"))
	{
		y_start = ini->ReadInteger();
		y_end = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "damage"))
		damage = ini->ReadInteger();
	if (!strcmp(ini->Variable(), "particles"))
		particles = ini->ReadBool();
	if (!strcmp(ini->Variable(), "animation"))
	{
		char *s = ini->ReadQString();
		anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist[s]));
		free(s);
	}
	if (!strcmp(ini->Variable(), "interval"))
	{
		intervals.push_back(ini->ReadInteger());
		pauseintervals.push_back(ini->ReadInteger());
	}
	if (!strcmp(ini->Variable(), "afall"))
		afall->LoadFromINI(ini);
}

void FallingEnemy::ProcessAI()
{
	if (visible)
	{
		Object *mc = gamescreen->GetPlay()->GetMainCharacter();
		if (!mc->IsDead())
			if (Intersect(mc))
				mc->DamageWD(damage);
		
		gamescreen->CNReset();
		while(!gamescreen->CNEnd())
		{
			Object *obj = gamescreen->CNGet();
			if (!obj->IsDead())
				if (Intersect(obj))
					obj->DamageWD(damage);
			gamescreen->CNNext();
		}
	}
	
	if ((current_interval == 0) && (framecounter == 0))
	{
		ypos = y_start << 8;
		yd = (y_end - y_start << 8) / intervals[0];
		if (IsOnScreen())
			afall->Play();
	}
	
	if (framecounter < intervals[current_interval])
		ypos += yd;
	else
		Hide();
	
	framecounter++;
	if (framecounter >= intervals[current_interval]+pauseintervals[current_interval])
	{
		framecounter = 0;
		current_interval++;
		if (current_interval >= intervals.size())
			current_interval = 0;
		ypos = y_start << 8;
		yd = (y_end - y_start << 8) / intervals[current_interval];
		Show();
		if (IsOnScreen())
			afall->Play();
	}
}