#define DEBUGMODE

#include "CollectableObject.h"
#include "Play.h"
#include "GameScreen.h"
#include "AudioSampler.h"

CollectableObject::CollectableObject(GameScreen *gs)
	:Object(gs, false),
	collect_type(0),
	value(0)
{
	type = OBJTYPE_COLLECTABLE;
	health = 100;
	fullhealth = 100;
	user_controlled = false;
	is_character = false;
	
	acollect = new AudioSampler(GetSound());
}

void CollectableObject::ReadProperties(MyINI *ini)
{
	Object::ReadProperties(ini);
	
	if (!strcmp(ini->Variable(), "animation"))
	{
		char *s = ini->ReadQString();
		anims.push_back(new AnimPlayer(gamescreen->GetResources()->animlist[s]));
		free(s);
	}
	if (!strcmp(ini->Variable(), "collecttype"))
	{
		collect_type = ini->ReadInteger();
		value = ini->ReadInteger();
	}
	if (!strcmp(ini->Variable(), "acollect"))
		acollect->LoadFromINI(ini);
}

void CollectableObject::ProcessAI()
{
	Object *obj = gamescreen->GetPlay()->GetMainCharacter();
	if (Intersect(obj))
	{
		acollect->Play();
		switch( collect_type )
		{
			case 0: // Save
				gamescreen->GetPlay()->AddSave();
				break;
			case 1: // Health plus
				obj->AddHealth(value);
				obj->SetHealthbarLife(100);
				break;
		}
		if (should_respawn)
			gamescreen->SetupRespawn(this);
		//Destroy();
		SwitchToState(STATE_KILL, 0, 0);
	}
}