#ifndef		TIGCPB_BUTTONS_H
#define		TIGCPB_BUTTONS_H

#include <allegro.h>
#include <vector>

#define	BTN_LEFT	0
#define	BTN_RIGHT	1
#define	BTN_UP	2
#define	BTN_DOWN	3
#define	BTN_SPK(i)	3+i
#define	BTN_ACT1	13
#define	BTN_ACT2	14
#define	BTN_ACT3	15
#define	BTN_ACT4	16

#define	BTN_NGS	17
#define	BTN_PGS	18

class Buttons;

typedef
	struct _BUTTON
	{
		int scancode;
		int joy1, joy2;
		int joybnum;
		bool c_kbstate;
		bool o_kbstate;
	} BUTTON;

class Buttons
{
	public:
		std::vector <BUTTON> buttons;
		
		Buttons()
		{
			SetToDefault();
		}
		
		void SetToDefault()
		{
			buttons.empty();
			Add(KEY_LEFT, 0, 0, 0);
			Add(KEY_RIGHT, 0, 0, 0);
			Add(KEY_UP, 0, 0, 0);
			Add(KEY_DOWN, 0, 0, 0);
			Add(KEY_Q, 0, 0, 0);
			Add(KEY_W, 0, 0, 0);
			Add(KEY_E, 0, 0, 0);
			Add(KEY_A, 0, 0, 0);
			Add(KEY_S, 0, 0, 0);
			Add(KEY_D, 0, 0, 0);
			Add(KEY_Z, 0, 0, 0);
			Add(KEY_X, 0, 0, 0);
			Add(KEY_C, 0, 0, 0);
			Add(KEY_LCONTROL, 0, 0, 0);
			Add(KEY_ALT, 0, 0, 0);
			Add(KEY_SPACE, 0, 0, 0);
			Add(KEY_ENTER, 0, 0, 0);
			Add(KEY_O, 0, 0, 0);
			Add(KEY_I, 0, 0, 0);
		}
		
		void Add( int scancode, int joybnum, int joy1, int joy2 )
		{
			BUTTON b;
			b.scancode = scancode;
			b.joybnum = joybnum;
			b.joy1 = joy1;
			b.joy2 = joy2;
			b.c_kbstate = false;
			b.o_kbstate = false;
			buttons.push_back(b);
		}
		
		void LoadFromConfig()
		{
			// To-do
		}
		
		int KeyDown( int id )
		{
			return buttons[id].c_kbstate;
			//key[buttons[id].scancode];
		}
		
		int KeyPress( int id )
		{
			return buttons[id].c_kbstate && !buttons[id].o_kbstate;
		}
		
		int JoyState( int id )
		{
			// To-do
			return 0;
		}
		
		void Update()
		{
			for( int i = 0; i < buttons.size(); i++ )
			{
				buttons[i].o_kbstate = buttons[i].c_kbstate;
				buttons[i].c_kbstate = key[buttons[i].scancode];
			}
		}
};

#endif		// TIGCPB_BUTTONS_H