#ifndef		TIGCPB_AUDIOSAMPLER_H
#define		TIGCPB_AUDIOSAMPLER_H

#include <allegro.h>
#include "Sound.h"
#include "MyINI.h"

class Object;

class AudioSampler
{
	private:
		Sound *sound;
		
		SAMPLE *sample;
		int voice;
		
		char objid[64];
		int
			framecounter,
			interval,
			sample_num,
			volume,
			t_fadein, t_fadeout;
		
		bool objvalid, is_playing;
	public:
		AudioSampler(Sound *snd);
		~AudioSampler();
		
		void LoadFromINI(MyINI *ini);
		
		void Play();
		void PlayLooped();
		void Stop();
		void Frametick();
		void Reset() { framecounter = interval; }
		
		void SetInterval( int intv ) { interval = intv; }
		void SetSamplenum( int sn ) { sample_num = sn; }
		void SetVolume( int vol ) { volume = vol; }
		void SetObjectID( char *id ) { strcpy(objid, id); objvalid = true; }
		void SetFadeInTime( int time ) { t_fadein = time; }
		void SetFadeOutTime( int time ) { t_fadeout = time; }
		
		void FadeInTick();
		void FadeOutTick();
		
		bool IsPlaying() { return is_playing; }
		bool Active() { return voice_get_position(voice)!=-1; }
		int Volume() { return voice_get_volume(voice); }
		
		void ResetCounter() { framecounter = 0; }
		
		char *AudioSample() { return objid; }
};

#endif		// TIGCPB_AUDIOSAMPLER_H