//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//palette.cpp
//handles the palette stuff

#include "palette.h"
#include "input_functions.h"

//holds the palette
//makes it easier to handle
struct SPaletteEntry
{
	PALETTE pal;
};

vector<SPaletteEntry> g_vPalettes;//holds the palette entries
int g_nCurrentPalette;//current palette entry

//loads the palette entries(as defined in the settings.ini file)
void LoadPalettes()
{
	int n = 0;
	char token[50];

	while(true)
	{
		sprintf(token, "palette%d", n);

		const char* name = get_config_string("", token, "");

		if(0 == strcmp(name, ""))
			break;

		SPaletteEntry pal;

		string path("palettes/");
		path.append(name);

		BITMAP* bmp = load_bitmap(path.c_str(), pal.pal);

		g_vPalettes.push_back(pal);

		destroy_bitmap(bmp);

		n++;
	}

	g_nCurrentPalette = get_config_int("", "current_palette", 0);
	g_nCurrentPalette %= g_vPalettes.size();

	set_palette(g_vPalettes[g_nCurrentPalette].pal);
}

//handles the palette switchig routines
void UpdatePalettes()
{
	bool changed = false;
	if(IsKeyJustPressed(KEY_F5))
	{
		g_nCurrentPalette--;
		changed = true;
	}
	if(IsKeyJustPressed(KEY_F6))
	{
		g_nCurrentPalette++;
		changed = true;
	}

	if(changed)//prevents unnecessary palette switching
	{
		if(g_nCurrentPalette < 0)
			g_nCurrentPalette += g_vPalettes.size();

		g_nCurrentPalette %= g_vPalettes.size();

		set_palette(g_vPalettes[g_nCurrentPalette].pal);
	}
}

//saves the palette selection to the ini file
void SavePaletteChanges()
{
	set_config_int("", "current_palette", g_nCurrentPalette);
}
