//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//menu.cpp
//houses the menu functions
//there is an unfinished skeleton of network support in the DoMenu function
//it is never called... it will need to be fleshed out eventually

#include "mouse.h"
#include "types.h"
#include "input_functions.h"
#include "sound.h"
#include "palette.h"
#include "galaxy.h"
#include "gfx.h"
#include "game.h"
#include "network.h"
#include "menu.h"

extern int g_nMouseX;
extern int g_nMouseY;

extern bool g_bQuit;
extern BITMAP* GetDrawPage();
extern void ShowPage();

extern SAMPLE* butt;

int g_nCurScreen = 0;//current menu screen

int g_nSelection = 0;//which map we selected

int g_nNumComputerPlayers = 0;//the number of computer players we selected

int g_nPlayerRace = 0;//the chosen player race

int g_nGameType = 1;//the chosen game type

int g_nMaxPoints = 10;//maximum number of points

int g_nPlayerNumber = 0;//player number of the human who is at this computer(used in multiplayer)

string g_sPlayerName;//player name

string g_sServerAddress;//a string containing the server's address(multiplayer)

//a structure describing the galaxy entry in the selection screen
struct SGalaxyEntry
{
	BITMAP* bmp;
	string name;
	string file;
	int num_players;
};

vector<SGalaxyEntry> g_pGalEntries;//array of entries

//caps the number of computer players
void FixUpNumComputerPlayers()
{	
	if(g_nNumComputerPlayers < 0)
		g_nNumComputerPlayers = 0;
	if(g_nNumComputerPlayers > g_pGalEntries[g_nSelection].num_players - 1)
		g_nNumComputerPlayers = g_pGalEntries[g_nSelection].num_players - 1;
}	

//quit game
int b_quit()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	return 4;
}

//start a new single player game
int b_newgame()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	return 8;
}

//advances the selection cursor
int b_next()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nSelection++;
	if(g_nSelection >= g_pGalEntries.size())
		g_nSelection = g_pGalEntries.size() - 1;
	FixUpNumComputerPlayers();
	return 0;
}

//decreases the selection cursor
int b_prev()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nSelection--;
	if(g_nSelection < 0)
		g_nSelection = 0;
	FixUpNumComputerPlayers();
	return 0;
}

//starts the game
int b_start()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	return 64;
}

//returns back to the previous screen
int b_back()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	return 32;
}	

//initalizes the edit mode, to capture the new player's name
int b_name()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	return 4;
}

//increases the number of computer players
int b_inc_num()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nNumComputerPlayers++;
	FixUpNumComputerPlayers();
	return 0;
}

//decreases the number of computer players
int b_dec_num()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nNumComputerPlayers--;
	FixUpNumComputerPlayers();
	return 0;
}

//toggles the selected race
int b_change_race()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nPlayerRace = (g_nPlayerRace + 1) % 3;
	return 8;
}

//toggles the selected game type
int b_change_gametype()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nGameType = (g_nGameType + 1) % 2;
	return 16;
}

//increases the maximum score
int b_inc_score()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nMaxPoints += 5;
	return 0;
}

//decreases the maximum score
int b_dec_score()
{
	PlaySound((SAMPLE*)g_pData[_Button].dat, false);
	g_nMaxPoints -= 5;
	if(g_nMaxPoints < 5)
		g_nMaxPoints = 5;
	return 0;
}

//the main menu screen
SButton screen0[] = 
{
	{1,		150, 180, 100, 100,		0, 0, 0,	0, 0,1},

	{1,		-50, 440, 100, 20,		0, 0, 0,	b_newgame, "New Game",1},
	{1,		-50, 480, 100, 20,		0, 0, 0,	b_quit, "Quit",1},

	{0,		0, 0, 0, 0,				0, 0, 0,	0,0,0}
};

//the map selection screen
SButton screen1[] = 
{
	{1,		150, 30, 100, 100,		0, 0, 0,	0, 0,1},

	{1,		-50, -30, 100, 20,		0, 0, 0,	b_start, "Start",1},
	{1,		150, -30, 100, 20,		0, 0, 0,	b_back, "Back",1},
	{1,		100, 50 + _GALAXY_THUMB_SIZE / 2 - 25, 50, 50, 0, 0, 0, b_prev, "<",1},
	{1,		-125, 50 + _GALAXY_THUMB_SIZE / 2 - 25, 50, 50, 0, 0, 0, b_next, ">",1},

	{1,		-250, -30, 100, 20,		0, 0, 0,	b_name, "Name:",1},

	{1,		240, 420, 15, 15,		0, 0, 0,	b_inc_num, "+",1},
	{1,		255, 420, 15, 15,		0, 0, 0,	b_dec_num, "-",1},
	{1,		50, 440, 200, 15,		0, 0, 0,	b_change_race, "Race:",0},
	{1,		50, 460, 300, 15,		0, 0, 0,	b_change_gametype, "Game Type:",0},
	{1,		240, 480, 15, 15,		0, 0, 0,	b_inc_score, "+",1},
	{1,		255, 480, 15, 15,		0, 0, 0,	b_dec_score, "-",1},

	{0,		0, 0, 0, 0,				0, 0, 0,	0,0,0}
};

//returns the number of bots
int GetNumBots()
{
	return g_nNumComputerPlayers;
}

//handles a button object
int HandleButton(SButton* but)
{
	int ret = 1;
	BITMAP* bmp = 0;
	int color = 100;

	//checks if the mouse is in the bounding rectangle of the button
	if(g_nMouseX > but->x && g_nMouseX < but->x + but->w
		&&
		g_nMouseY > but->y && g_nMouseY < but->y + but->h)
	{
		if(IsMKeyDown(0))//left mouse button down
		{
			bmp = but->bmp_down;
			color = 120;
		}
		else//just highlighted
		{
			bmp = but->bmp_high;
			color = 120;
		}

		if(IsMKeyJustReleased(0))//we clicked
		{
			if(but->fn)//call the function if it is present
				ret = ((int (*)(void)) but->fn) ();
		}
	}
	else//mouse is elsewhere
	{
		bmp = but->bmp_idle;
	}

	if(bmp == 0)//try to get idle bmp
		bmp = but->bmp_idle;

	if(bmp != 0)//draw the bitmap if it is present
		draw_sprite(GetDrawPage(), bmp,  but->x,  but->y);

	if(but->text)//if we have text, draw it
	{
		switch(but->align)
		{
		case 0:
			textout_ex(GetDrawPage(), font, but->text, but->x, 
				but->y + (but->h - text_height(font)) / 2, color, -1);
			break;
		case 1:
			textout_centre_ex(GetDrawPage(), font, but->text, but->x + but->w / 2, 
				but->y + (but->h - text_height(font)) / 2, color, -1);
			break;
		case 2:
			textout_right_ex(GetDrawPage(), font, but->text, but->x + but->w, 
				but->y + (but->h - text_height(font)) / 2, color, -1);
			break;
		}
	}

	return ret;
}

//edit box strings
string g_sEditBoxString;	//this is the current string
string g_sEditBoxStringPrev;//this is the previous string, invoked when we press up in the textbox

int g_nCursor_pos = 0;		//cursor position in the edit box

//sets the edit box string
void SetEditBoxString(const char* str)
{
	g_sEditBoxStringPrev = g_sEditBoxString;//save the previous entry
	g_sEditBoxString.assign(str);
	g_nCursor_pos = g_sEditBoxString.size();
}

//returns the edit box string
const char* GetEditBoxString()
{
	return g_sEditBoxString.c_str();
}

//handles the edit box stuff
//returns -1 to signify canceling
//returns 1 to signify ok'ing
//otherwise returns 0
int HandleEditBox(bool draw_snap)
{
	static int count = 0;//used as a silly fps cap, so we don't register every single keypress

	//check if we have stuff in the key buffer
	if(keypressed())
	{	
		char ch = readkey() & 0xff;
		if(ch >= ' ')
		{
			g_sEditBoxString.insert(g_nCursor_pos, " ");
			g_sEditBoxString[g_nCursor_pos] = ch;
			g_nCursor_pos++;
		}
	}

	bool something_down = false;//a dirty flag, combined with the count in the logic

	if(IsKeyDown(KEY_ESC))
	{
		return -1;//cancel
	}

	if(IsKeyJustPressed(KEY_ENTER))
	{
		return 1;//ok
	}
	if(IsKeyDown(KEY_BACKSPACE))
	{
		something_down = true;
		if(count == 0)
		{
			if(g_nCursor_pos > 0)
			{
				g_sEditBoxString.erase(g_nCursor_pos - 1, 1);
				g_nCursor_pos--;
			}
		}
	}
	if(IsKeyDown(KEY_DEL))
	{
		something_down = true;
		if(count == 0)
		{
			if(g_nCursor_pos < g_sEditBoxString.size())
			{
				g_sEditBoxString.erase(g_nCursor_pos, 1);
			}
		}
	}
	if(IsKeyDown(KEY_LEFT))
	{
		something_down = true;
		if(count == 0)
		{
			g_nCursor_pos--;
		}
	}
	
	if(IsKeyJustPressed(KEY_UP))
	{
		string temp = g_sEditBoxStringPrev;//get the previous entry
		SetEditBoxString(temp.c_str());
	}

	if(IsKeyDown(KEY_RIGHT))
	{
		something_down = true;
		if(count == 0)
		{
			g_nCursor_pos++;
		}
	}

	//cap the cursor
	if(g_nCursor_pos < 0)
		g_nCursor_pos = 0;
	if(g_nCursor_pos > g_sEditBoxString.size())
		g_nCursor_pos = g_sEditBoxString.size();
	
	if(!something_down)//throttling mechanism
		count = 0;
	else
	{
		count += 1;
		count %= 5;
	}

	//now draw the text
	int len = gui_strlen(g_sEditBoxString.c_str());
	int height = text_height(font) / 2;

	string str = g_sEditBoxString.substr(0, g_nCursor_pos);

	int pos = gui_strlen(str.c_str()) - len / 2 + SCREEN_W / 2;//get the cursor location

	len += 20;

	//draw the backing
	drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);

	rectfill(GetDrawPage(), (SCREEN_W - len) / 2, SCREEN_H / 2 - 8, (SCREEN_W + len) / 2, 
		SCREEN_H / 2 + 8, 30);

	solid_mode();

	//draw the cursor and the text
	vline(GetDrawPage(), pos, SCREEN_H / 2 - height, SCREEN_H / 2 + height, 112);
	textout_centre_ex(GetDrawPage(), font, g_sEditBoxString.c_str(), SCREEN_W / 2, SCREEN_H / 2 - height,
		112, -1);

	return 0;
}

//handle an array of buttons
//returns 1 if nothing of note happened
int DoButtons(SButton* buttons)
{
	int ret = 1;
	for(int ii = 0; buttons[ii].dummy != 0; ii++)
	{
		SButton* but = &buttons[ii];
		ret |= HandleButton(but);
	}
	return ret;
}

//adds a galaxy entry to the select screen
//a callback for the for_each_file_ex
int AddGalEntry(const char *filename, int attrib, void *param)
{
	set_config_file(filename);
	SGalaxyEntry entry;
	entry.file.assign(filename);
	entry.name.assign(get_config_string("", "name", "Unnamed"));
	string name("missions/");
	name.append(get_config_string("", "space_file", ""));
	
	entry.bmp = CreateGalaxyThumb(name.c_str());
	entry.num_players = GetNumPlayers(filename);

	g_pGalEntries.push_back(entry);

	return 0;
}

//initializes some aspects of the menus
void InitMenu()
{
	DeInitMenu();
	//fix up stuff dependent on runtime data
	screen0[0].bmp_idle = (BITMAP*)g_pData[_Title].dat;

	screen0[0].w = screen0[0].bmp_idle->w;
	screen0[0].x = (SCREEN_W - screen0[0].w) / 2;

	screen0[1].x += SCREEN_W / 2;
	screen0[2].x += SCREEN_W / 2;

	screen1[4].x += SCREEN_W;
	screen1[1].x += SCREEN_W / 2;
	screen1[2].x += SCREEN_W / 2;
	screen1[5].x += SCREEN_W / 2;

	screen1[1].y += SCREEN_H;
	screen1[2].y += SCREEN_H;
	screen1[5].y += SCREEN_H;

	//create a galaxy list
	for_each_file_ex("missions/*.mis", 0, 0, AddGalEntry, 0);
}

//destroy stuff from the menu
void DeInitMenu()
{
	for(unsigned int ii = 0; ii < g_pGalEntries.size(); ii++)
	{
		destroy_bitmap(g_pGalEntries[ii].bmp);
	}
}

//draw the galaxy selector construct
void DrawGalalaxySelector(int selection)
{
	int width = SCREEN_W / _GALAXY_THUMB_SIZE - 2;

	if(width % 2 == 0)//we want an odd size, so the selection is in the middle of the screen
		width--;

	width /= 2;

	for(int ii = -width; ii <= width; ii++)//now we iterate across the positions
	{
		if(ii + selection < 0)//no displaying stuff below the selection treshold
			continue;
		if(ii + selection >= g_pGalEntries.size())//no display stuff above the selection treshold
			break;

		int x = _GALAXY_THUMB_SIZE * ii + SCREEN_W / 2;
		
		draw_sprite(GetDrawPage(), g_pGalEntries[ii + selection].bmp, x - _GALAXY_THUMB_SIZE / 2, 50);
		
		//draw the selection rectangle
		if(ii == 0)
		{
			rect(GetDrawPage(), x - _GALAXY_THUMB_SIZE / 2, 50, x + _GALAXY_THUMB_SIZE / 2,
				50 + _GALAXY_THUMB_SIZE, 100);
		}

		textout_centre_ex(GetDrawPage(), font, g_pGalEntries[ii + selection].name.c_str(), 
			x, 50 + _GALAXY_THUMB_SIZE + 15, 112, -1);
	}
}

//get the mission name
const char* GetMisName()
{
	return g_pGalEntries[g_nSelection].file.c_str();
}

//returns the player name
const char* GetPlayerName()
{
	return g_sPlayerName.c_str();
}

//sets the player name
void SetPlayerName(const char* str)
{
	g_sPlayerName.assign(str);
}

//handles the menu logic/drawing
//return values
//-1 = quit
//-2 = quit and start game
int DoMenu(SMissionProfile* profile)
{
	int ret = -1;
	bool edit_mode = false;
	char buf[100];

	int connect_state = 0;//used for network clients

	int game_ntype = 0;//network type: 0 - single player, 1 - multi-server, 2 - multi-client

	//strings for the toggleable buttons
	string race_button_str;
	string gametype_button_str;
	string name_button_str;

	//current screen array
	SButton* cur_screen = screen0;

	COLOR_MAP minus_map;
	CreateSubtractionMap(minus_map);

	g_nCurScreen = 0;
	
	//init the race button text
	switch(g_nPlayerRace)
	{
	case 0:
		race_button_str.assign("Race: Communists");
		break;
	case 1:
		race_button_str.assign("Race: Anarchists");
		break;
	default:
		race_button_str.assign("Race: Capitalists");
		break;
	}

	//init the game type button text
	switch(g_nGameType)
	{
	case 0:
		gametype_button_str.assign("Game Type: Deathmatch");
		break;
	default:
		gametype_button_str.assign("Game Type: Bounty");
		break;
	}

	//init the name button text
	name_button_str.assign("Name:");
	name_button_str += g_sPlayerName;

	while(!g_bQuit)
	{
		int snap = g_nTime;//fps capping mechanism

		UpdatePalettes();
		UpdateInput();
		UpdateSound(0,0);

		if(g_nCurScreen == 2)//enter ip address screen
		{
			if(0 != HandleEditBox(false))
			{
				edit_mode = false;
				g_sServerAddress = g_sEditBoxString;

				if(StartClient())//if client was created we go to a loading screen
				{
					g_nCurScreen = 3;
					//cur_screen = screen3;
				}
				else
				{
					g_nCurScreen = 0;
					cur_screen = screen1;
				}
			}
		}
		else if(g_nCurScreen == 3)//connecting screen
		{
			sprintf(buf, "Connecting to: %s", g_sServerAddress.c_str());
			textout_centre_ex(GetDrawPage(), font, buf, 
				SCREEN_W / 2, SCREEN_H / 2, 100, -1);
			if(connect_state == 0)//initiate connecting procedue
			{
				if(Connect(g_sServerAddress.c_str()))
				{
					connect_state = 1;
					
					//we connected, send the hello package
					//it has the player name
					SPacket* packet = new SPacket;
					packet->type = _HELLO_PACKAGE;
					packet->data_len = g_sPlayerName.length();
					packet->data = malloc(packet->data_len);
					memcpy(packet->data, g_sPlayerName.c_str(), packet->data_len);
					BroadcastPacket(packet);
				}
				else//we failed, go back to main screen
				{
					DestroyHost();
					g_nCurScreen = 0;
					cur_screen = screen1;
				}
			}
			if(connect_state == 1)
				//now we wait for the responce package, which
			{
				SPacket* packet = 0;
				ENetPeer* peer = 0;
				switch(HandleNetwork(&packet, &peer))
				{
				case 2://receive package
					if(packet->type == _INI_RESPONSE)
					{
						g_nPlayerNumber = *((int*)packet->data);
						//yay, we got it
						//now we just go the the wait screen
						g_nCurScreen = 4;
						//cur_screen = screen4; need to make the screen
						delete packet;
					}
					break;
				case 3://disconnected(or rejected)
					DestroyHost();
					g_nCurScreen = 0;
					cur_screen = screen1;
					break;
				}
			}
		}
		else//these screens can get button input
		{
			if(g_nCurScreen == 1)//select screen
			{
				if(!edit_mode)//i.e. not entering the name
				{
					//keyboard access to the map selector
					if(IsKeyJustPressed(KEY_LEFT))
						b_prev();
					if(IsKeyJustPressed(KEY_RIGHT))
						b_next();
					if(IsKeyJustPressed(KEY_ENTER))
					{
						PlaySound((SAMPLE*)g_pData[_Button].dat, false);
						ret = -2;
						goto EXIT;
					}
				}
		
				if(edit_mode)//we are entering a name
				{
					color_map = &minus_map;
					int ret = HandleEditBox(false);
					if(ret != 0)
					{
						edit_mode = false;
						PlaySound((SAMPLE*)g_pData[_Button].dat, false);
						if(ret == 1)
						{
							name_button_str.assign("Name:");
							name_button_str += g_sEditBoxString;
							g_sPlayerName = g_sEditBoxString;
						}
					}
				}

				if(game_ntype == 1) //we are a server(this section is obviously incomplete,
									//it would handle the greeting exchange of packets
									//and sending the maps etc to the players)
				{
					SPacket* packet = 0;
					ENetPeer* peer = 0;
					switch(HandleNetwork(&packet, &peer))
					{
					case 1://connect
						break;
					case 2://receive
						break;
					case 3://disconnect
						break;
					}
				}
			}
			
			//set the button text
			screen1[5].text = name_button_str.c_str();
			screen1[9].text = gametype_button_str.c_str();
			screen1[8].text = race_button_str.c_str();
			
			int status = DoButtons(cur_screen);//do the current screen buttons
			if(status != 1)
			{
				if(g_nCurScreen == 0)//main menu
				{
					if(status & 4)//exit
					{
						goto EXIT;
					}
					if(status & 8)//new
					{
						g_nCurScreen = 1;
						cur_screen = screen1;
						game_ntype = 0;
					}
					if(status & 16)//multi - host
					{
						if(StartServer("127.0.0.1"))//I still need to figure out how to get the local
													//address of this computer, at this time
													//its just set to localhost
						{
							g_nCurScreen = 2;
							cur_screen = screen1;
							game_ntype = 1;
						}
					}
					if(status & 32)//multi - join
					{
						g_nCurScreen = 3;
						cur_screen = screen1;
						game_ntype = 2;
					}
				}
				if(g_nCurScreen == 1)//level select
				{
					if(status & 4)//name button
					{
						edit_mode = true;
						clear_keybuf();
						SetEditBoxString(g_sPlayerName.c_str());
					}
					if(status & 8)//race button
					{
//						printf("race: %d\n", g_nPlayerRace);
//						printf("type: %d\n", g_nGameType);
						switch(g_nPlayerRace)
						{
						case 0:
							race_button_str.assign("Race: Communists");
							break;
						case 1:
							race_button_str.assign("Race: Anarchists");
							break;
						default:
							race_button_str.assign("Race: Capitalists");
							break;
						}
					}
					if(status & 16)//gametype button
					{
//						printf("race: %d\n", g_nPlayerRace);
//						printf("type: %d\n", g_nGameType);
						switch(g_nGameType)
						{
						case 0:
							gametype_button_str.assign("Game Type: Deathmatch");
							break;
						default:
							gametype_button_str.assign("Game Type: Bounty");
							break;
						}
					}
					if(status & 32)//back
					{
						g_nCurScreen = 0;
						cur_screen = screen0;
					}
					if(status & 64)//start game
					{
						ret = -2;
						goto EXIT;
					}
				}
			}
		}
		
		if(g_nCurScreen == 0)//main screen
		{
			textout_ex(GetDrawPage(), font, "By SiegeLord", 
				15, SCREEN_H - 15, 100, -1);
			textout_right_ex(GetDrawPage(), font, "Copyright (C) 2006-2008 Version: 0.9", 
				SCREEN_W - 15, SCREEN_H - 15, 100, -1);
		}
		else if(g_nCurScreen == 1)
		{
			//draw stuff
			DrawGalalaxySelector(g_nSelection);
			textprintf_ex(GetDrawPage(), font, 50, 400, 100, -1, "Max Players: %d", g_pGalEntries[g_nSelection].num_players);
			textprintf_ex(GetDrawPage(), font, 50, 421, 100, -1, "Computer Players: %d", g_nNumComputerPlayers);
			textprintf_ex(GetDrawPage(), font, 50, 481, 100, -1, "Max Score: %d", g_nMaxPoints);	
		}
		else if(g_nCurScreen == 2)//enter ip address screen
		{
			color_map = &minus_map;

			textout_centre_ex(GetDrawPage(), font, "Enter IP address you wish to join:", 
				SCREEN_W / 2, SCREEN_H / 2 - 100, 100, -1);
		}

		if(!edit_mode)
		{
			DrawMouse();
		}
		
		//update stuff
		ShowPage();
		
		while(g_nTime - snap == 0)
			rest(1);
	}

EXIT:;
	UpdateSound(0,0);//reset sound

	profile->mission_name = g_pGalEntries[g_nSelection].file;//fill out the profile
	profile->num_bots = g_nNumComputerPlayers;
	

	return ret;
}
