//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//planet.cpp
//handles the sound things

#include "sound.h"

//the sound structure
struct SSound
{
	int x;//position
	int y;
	SAMPLE* smpl;//the actual sample
	bool positionable;//can this be attenuated by the position?
	bool playing;//is it playing?
	bool loop;//is it looping?
	int voice;//the voice instance for this sound, used for position stuff
};

list<SSound> g_lSounds;//holds all of the sounds

//creates a new global sound
//doesn't actually start playing it though
void PlaySound(SAMPLE* smpl, bool loop)
{
	SSound sound;
	sound.x = 0;
	sound.positionable = false;
	sound.smpl = smpl;
	sound.playing = false;
	sound.loop = loop;
	sound.voice = -1;//tells us that we need to start it later on
	
	g_lSounds.push_back(sound);
}

//creates a new positionalble sound
//doesn't actually start playing it though
void PlaySound(SAMPLE* smpl, int x, int y, bool loop)
{
	SSound sound;
	sound.x = x;
	sound.y = y;
	sound.positionable = true;
	sound.smpl = smpl;
	sound.playing = false;
	sound.loop = loop;
	sound.voice = -1;

	g_lSounds.push_back(sound);
	
}

//handles the sound stuff
void UpdateSound(int view_x, int view_y)
{
	//loop across the sounds doing stuff
	for(list<SSound>::iterator it = g_lSounds.begin(); it != g_lSounds.end(); it++)
	{
		SSound* sound = &(*it);
		if(sound->voice < 0)//start the sound as needed
		{
			sound->voice = play_sample(sound->smpl, 255, 128, 1000, sound->loop);
		}

		if(!voice_check(sound->voice))//if we are not playing, the remove it
		{
			it = g_lSounds.erase(it);
			continue;
		}

		if(sound->positionable)//if the sound is positionable, we can do some things to it
		{
			float dx = sound->x - view_x - SCREEN_W / 2;
			float dy = sound->y - view_y - SCREEN_H / 2;

			int dist = dx * dx + dy * dy;
			if(dist == 0)
				dist = 1;

			int volume = 255.0f * 100000.0f / (dist);//attenuate by the distance
			if(volume > 255)
				volume = 255;

			int pan = 128.0f * dx / 1000.0f + 128.0f;//handle the pan

			voice_set_pan(sound->voice, pan);
			voice_set_volume(sound->voice, volume);
		}
	}
}
