//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//npc.cpp
//handles the npc's

#include "bomb.h"
#include "gfx.h"
#include "npc.h"
#include "sound.h"

extern int g_nGameType;

//draws an npc
void DrawNPC(SNPC* npc, int view_x, int view_y)
{
	if(npc->type == 0)//the battle pod
		aa_circle(GetDrawPage(), npc->x - view_x, npc->y - view_y, 5, 112);
	else if(npc->type == 1)//bounty circle
	{
		aa_circle(GetDrawPage(), npc->x - view_x, npc->y - view_y, npc->val2 / 16, 118);
		putpixel(GetDrawPage(), npc->x - view_x + 1, npc->y - view_y, 118);
		putpixel(GetDrawPage(), npc->x - view_x, npc->y - view_y + 1, 118);
		putpixel(GetDrawPage(), npc->x - view_x - 1, npc->y - view_y, 118);
		putpixel(GetDrawPage(), npc->x - view_x, npc->y - view_y - 1, 118);
	}
}

//handles the movement of the npc
//returns 0 if dead
int MoveNPC(vector<SPlanet>* planets, list<SNPC>* npcs, list<SBomb> *bombs, SNPC* npc, BITMAP* galaxy, BITMAP* subspace)
{
	float cs = cosf(npc->theta);
	float sn = sinf(npc->theta);

	//the val's of the npc for this type are as follows
	//fire rate, current energy, max energy, source, fire count
	if(npc->type == 0)
	{
		npc->val2 -= 5 * (100 - _getpixel(subspace, npc->x, npc->y)) / 2;	//decrease energy(divided by 2
																			//because this thing moves
																			//at half speed

		npc->x += cs * 0.5;//move 0.5 unit
		npc->y += sn * 0.5;

		npc->val5++;//increase the fire count

		if(npc->val5 > npc->val1)//if the fire count is bigger than the fire rate parameter we fire
		{
			PlaySound((SAMPLE*)g_pData[_Npc_fire].dat, npc->x, npc->y, false);

			npc->val5 = 0;//reset 

			//find the closest plane
			float closest_dist = 0;
			bool have_something = false;
			int dest_x = 0, dest_y = 0;
			bool first = true;

			for(unsigned int ii = 0; ii < planets->size(); ii++)
			{
				if(ii == (unsigned int)(npc->val4))
					continue;
				SPlanet* planet = &((*planets)[ii]);
				if(planet->dead)
					continue;
				float d = (planet->x - npc->x) * (planet->x - npc->x) + 
					(planet->y - npc->y) * (planet->y - npc->y);
				
				if(d < closest_dist || first)
				{
					first = false;
					closest_dist = d;
					dest_x = planet->x;
					dest_y = planet->y;
					have_something = true;	
				}
			}

			if(g_nGameType == 1)//bounty, so we try to find bounty circles
			{
				if(!have_something)
					closest_dist = 100000000;//large

				for(list<SNPC>::iterator it = npcs->begin(); it != npcs->end(); it++)
				{
					SNPC* cnpc = &(*it);
					if(cnpc->type != 1)
						continue;
					float d = (cnpc->x - npc->x) * (cnpc->x - npc->x) + 
						(cnpc->y - npc->y) * (cnpc->y - npc->y);
					d /= 2;//we'd much rather hit this..., so we divide the distance by root 2
					if(d < closest_dist)
					{
						have_something = true;
						dest_x = cnpc->x;
						dest_y = cnpc->y;
						closest_dist = d;
					}
				}
			}
			
			if(have_something)//we have a target, so we shoot
			{
				SBomb bomb;
				bomb.energy = npc->val3 / 10;
				bomb.life = _BOMB_LIFE * 2 + npc->val3 / 15;
				bomb.parent = false;
				bomb.radius = 0;
				bomb.source = npc->val4;
				bomb.subspace = false;
				bomb.wait = 0;
				bomb.x = npc->x;
				bomb.y = npc->y;
				bomb.theta = atan2f(dest_y - npc->y, dest_x - npc->x);
				bombs->push_back(bomb);
			}
		}
		if(npc->val2 < 0)
			return 0;
		return 1;
	}
	//the val's of the npc for this type are as follows
	//life, radius
	else if(npc->type == 1)
	{
		npc->val1 += 1;//increase life
		npc->val2 += 1;//increase radius
		if(npc->val1 > 600)//timed out
			return 0;
		if(npc->val1 < 0)//someone hit it
			return 0;
		return 1;
	}
	return 1;
}
