//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//gfx.cpp
//Handles the primitive drawing routines
//My circle/arc routines have issues at 45 degree positions, don't feel like fixing them

#include "gfx.h"

extern int g_nGameType;

BITMAP* g_bmpBuffer;//the two video pages

//used for functions who need to draw pretty much anything
BITMAP* GetDrawPage()
{
	return g_bmpBuffer;
}

//draws the video bitmap, and flips it
void ShowPage()
{
	blit(g_bmpBuffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	clear(g_bmpBuffer);
}

//initialize the graphics
bool InitGfx()
{
	//create the two pages
	g_bmpBuffer = create_bitmap(SCREEN_W, SCREEN_H);

	if(!g_bmpBuffer)
		return false;

	return true;
}

//the alpha blended put pixel routine... I guess it could be implemented as
//a series of colour mapping tables, but I think this is simpler
inline void blended_putpixel(BITMAP* bmp, int x, int y, int val, float rho)
{
	if(x < bmp->w && y < bmp->h && x > -1 && y > -1)
	{
		int v = _getpixel(bmp, x, y);
		v = float(v) * (1 - rho) + float(val) * rho;
		_putpixel(bmp, x, y, v);
	}
}
//draws an anti-aliased circle
void aa_circle(BITMAP* bmp, int _x, int _y, int radius, int color)
{
#define _PIXEL(a,b,c,d)									\
	{													\
		blended_putpixel(bmp, a + _x, b + _y, c, d);	\
	}													\

	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4
	bool needed = true;

	int end2 = (int)((0.707106781 * float(radius) + .5));//no idea why .29 works...
	if(end2 != end)
		needed = false;

	float r2 = float(radius);
	r2 *= r2;
	for(int x = 0; x <= end; x++)
	{
		float y = sqrtf(r2 - x * x);
		int Y = int(y);
		int Y2 = Y + 1;
		float f = y - Y;
		float f2 = 1 - f;
//		int __x, __y;

		int rho = color;

		int u = x;
		int v = Y;
		_PIXEL(u,v,rho,f2);
		_PIXEL(v,u,rho,f2);

		u = -x;
		_PIXEL(u,v,rho,f2);
		_PIXEL(v,u,rho,f2);

		u = x;
		v = -Y;
		_PIXEL(u,v,rho,f2);
		_PIXEL(v,u,rho,f2);

		u = -x;
		_PIXEL(u,v,rho,f2);
		_PIXEL(v,u,rho,f2);

		//pass 2

		u = x;
		v = Y2;
		_PIXEL(u,v,rho,f);
		_PIXEL(v,u,rho,f);

		u = -x;
		_PIXEL(u,v,rho,f);
		_PIXEL(v,u,rho,f);

		u = x;
		v = -Y2;
		_PIXEL(u,v,rho,f);
		_PIXEL(v,u,rho,f);

		u = -x;
		_PIXEL(u,v,rho,f);
		_PIXEL(v,u,rho,f);
		
	}

	if(!needed)
	{	
		_PIXEL(end2, end2, color, 1);
		_PIXEL(-end2, end2, color, 1);
		_PIXEL(-end2, -end2, color, 1);
		_PIXEL(end2, -end2, color, 1);
	}
}
//angles must be positive
void aa_arc(BITMAP* bmp, int _x, int _y, int radius, float _a1, float _a2, int color)
{
#undef _PIXEL
#define _PIXEL(a,b,c,d)									\
	{													\
		blended_putpixel(bmp, a + _x, b + _y, c, d);	\
	}													\

#define OCT0	1
#define OCT1	2
#define OCT2	4
#define OCT3	8
#define OCT4	16
#define OCT5	32
#define OCT6	64
#define OCT7	128

	int octant_flags = 0;
	int oct_to_check1 = 0;
	int oct_to_check2 = 0;

	//determine which octants are affected
	float a1 = _a2;
	float a2 = _a1;

	oct_to_check1 = int(a1 / AL_PI * 4.0f);
	oct_to_check2 = int(a2 / AL_PI * 4.0f);

	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4
	bool needed = true;

	int end2 = (int)((0.707106781 * float(radius) + .5));//no idea why .29 works...
	if(end2 != end)
		needed = false;

	int oct = oct_to_check2;
	octant_flags |= 1 << oct;
	while(oct != oct_to_check1)
	{
		oct++;
		oct %= 8;
		octant_flags |= 1 << oct;
		
	}
	bool hack = false;
	if(oct_to_check1 == oct_to_check2 && _a1 > _a2)//a hack, prevents a bug for highly obstuse angles
	{
		hack = true;
		octant_flags |= 255;
	}
	//octant_flags = OCT7 | OCT0;
	//oct_to_check1 = 7;
	//oct_to_check2 = 0;

	int x1 = float(radius) * cosf(a1);
	int y1 = float(radius) * sinf(a1);
	int x2 = float(radius) * cosf(a2);
	int y2 = float(radius) * sinf(a2);

//	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4
	float r2 = float(radius);
	r2 *= r2;

	if(!hack)
	{
	for(int x = 0; x <= end; x++)
	{
		float y = sqrtf(r2 - x * x);
		int Y = int(y);
		int Y2 = Y + 1;
		float f = y - Y;
		float f2 = 1 - f;
//		int __x, __y;

		int rho = color;

		int u = x;
		int v = Y;

		if(octant_flags & OCT1)
		{
			if(!(oct_to_check1 == 1 && u < x1) && !(oct_to_check2 == 1 && u > x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && u > y1) && !(oct_to_check2 == 0 && u < y2))
				_PIXEL(v,u,rho,f2)
		}

		u = -x;
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && u < x1) && !(oct_to_check2 == 2 && u > x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT7)
		{
			if(!(oct_to_check1 == 7 && u > y1) && !(oct_to_check2 == 7 && u < y2))
				_PIXEL(v,u,rho,f2)
		}

		u = x;
		v = -Y;
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && u > x1) && !(oct_to_check2 == 6 && u < x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT3)
		{
			if(!(oct_to_check1 == 3 && u < y1) && !(oct_to_check2 == 3 && u > y2))
				_PIXEL(v,u,rho,f2)
		}

		u = -x;
		if(octant_flags & OCT5)
		{
			if(!(oct_to_check1 == 5 && u > x1) && !(oct_to_check2 == 5 && u < x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && u < y1) && !(oct_to_check2 == 4 && u > y2))
				_PIXEL(v,u,rho,f2)
		}

		//pass 2

		u = x;
		v = Y2;
		if(octant_flags & OCT1)
		{
			if(!(oct_to_check1 == 1 && u < x1) && !(oct_to_check2 == 1 && u > x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && u > y1) && !(oct_to_check2 == 0 && u < y2))
				_PIXEL(v,u,rho,f)
		}

		u = -x;
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && u < x1) && !(oct_to_check2 == 2 && u > x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT7)
		{
			if(!(oct_to_check1 == 7 && u > y1) && !(oct_to_check2 == 7 && u < y2))
				_PIXEL(v,u,rho,f)
		}

		u = x;
		v = -Y2;
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && u > x1) && !(oct_to_check2 == 6 && u < x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT3)
		{
			if(!(oct_to_check1 == 3 && u < y1) && !(oct_to_check2 == 3 && u > y2))
				_PIXEL(v,u,rho,f)
		}

		u = -x;
		if(octant_flags & OCT5)
		{
			if(!(oct_to_check1 == 5 && u > x1) && !(oct_to_check2 == 5 && u < x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && u < y1) && !(oct_to_check2 == 4 && u > y2))
				_PIXEL(v,u,rho,f)
		}

	}
	}
	else//hack
	{
	for(int x = 0; x <= end; x++)
	{
		float y = sqrtf(r2 - x * x);
		int Y = int(y);
		int Y2 = Y + 1;
		float f = y - Y;
		float f2 = 1 - f;
//		int __x, __y;

		int rho = color;

		int u = x;
		int v = Y;

		if(octant_flags & OCT1)
		{
			if(!(oct_to_check1 == 1 && u < x1) && !(oct_to_check2 == 1 && u > x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && u > y1) && !(oct_to_check2 == 0 && u < y2))
				_PIXEL(v,u,rho,f2)
		}

		u = -x;
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && u < x1) && !(oct_to_check2 == 2 && u > x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT7)
		{
			if(!(oct_to_check1 == 7 && u > y1) && !(oct_to_check2 == 7 && u < y2))
				_PIXEL(v,u,rho,f2)
		}

		u = x;
		v = -Y;
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && u > x1) && !(oct_to_check2 == 6 && u < x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT3)
		{
			if(!(oct_to_check1 == 3 && u < y1) && !(oct_to_check2 == 3 && u > y2))
				_PIXEL(v,u,rho,f2)
		}

		u = -x;
		if(octant_flags & OCT5)
		{
			if(!(oct_to_check1 == 5 && u > x1) && !(oct_to_check2 == 5 && u < x2))
				_PIXEL(u,v,rho,f2)
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && u < y1) && !(oct_to_check2 == 4 && u > y2))
				_PIXEL(v,u,rho,f2)
		}

		//pass 2
		u = x;
		v = Y2;
		if(octant_flags & OCT1)
		{
			if(!(oct_to_check1 == 1 && u < x1) || !(oct_to_check2 == 1 && u > x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && u > y1) || !(oct_to_check2 == 0 && u < y2))
				_PIXEL(v,u,rho,f)
		}

		u = -x;
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && u < x1) || !(oct_to_check2 == 2 && u > x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT7)
		{
			if(!(oct_to_check1 == 7 && u > y1) || !(oct_to_check2 == 7 && u < y2))
				_PIXEL(v,u,rho,f)
		}

		u = x;
		v = -Y2;
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && u > x1) || !(oct_to_check2 == 6 && u < x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT3)
		{
			if(!(oct_to_check1 == 3 && u < y1) || !(oct_to_check2 == 3 && u > y2))
				_PIXEL(v,u,rho,f)
		}

		u = -x;
		if(octant_flags & OCT5)
		{
			if(!(oct_to_check1 == 5 && u > x1) || !(oct_to_check2 == 5 && u < x2))
				_PIXEL(u,v,rho,f)
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && u < y1) || !(oct_to_check2 == 4 && u > y2))
				_PIXEL(v,u,rho,f)
		}

	}
	}

	if(!needed)
	{	
//		int __x, __y, rho = color * 0.9;
		//end2++;
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && end2 > y1) && !(oct_to_check2 == 0 && end2 < y2))
				_PIXEL(end2, end2, color, 1)
		}
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && -end2 < x1) && !(oct_to_check2 == 2 && -end2 > x2))
				_PIXEL(-end2, end2, color, 1)
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && -end2 < y1) && !(oct_to_check2 == 4 && -end2 > y2))
				_PIXEL(-end2, -end2, color, 1)
		}
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && end2 > x1) && !(oct_to_check2 == 6 && end2 < x2))
				_PIXEL(end2, -end2, color, 1)
		}
	}
}

//draws an antialiased line between two points
void aa_line(BITMAP* bmp, int _x1, int _y1, int _x2, int _y2, int color)
{
	int x1, x2, y1, y2;

	int dx = _x2 - _x1;
	int dy = _y2 - _y1;

	if(abs(dx) > abs(dy))//shallow slope
	{		

		//clip the line to the bitmap
		//flip the points so the coords go left to right
		if(_x1 > _x2)
		{	
			x1 = _x2;
			x2 = _x1;
			y1 = _y2;
			y2 = _y1;
		}
		else
		{
			x1 = _x1;
			x2 = _x2;
			y1 = _y1;
			y2 = _y2;
		}

		int old_x1 = x1;
		int old_x2 = x2;

		//clip x coords
		if(x1 < 0)
			x1 = 0;
		if(x1 >= bmp->w)
			return;

		if(x2 < 0)
			return;
		if(x2 >= bmp->w)
			x2 = bmp->w;

		float d = float(dy) / float(dx);//slope

		y1 = y1 + float(x1 - old_x1) * d;//the new y, based on the clipped x and the slope
		y2 = y2 + float(x2 - old_x2) * d;

		float y = y1;
		for(int x = x1; x < x2; x++)//now we just iterate across the line, drawing two pixels
		{
			int Y = int(y);
			int Y2 = Y + 1;

			if(Y < 0)
			{
				if(d < 0)
					break;
				y += d;
				continue;
			}
			if(Y2 >= bmp->h)
			{
				if(d > 0)
					break;
				y += d;
				continue;
			}

			float f = fabs(y - Y);//fractional factor that determines how much of each pixel is shaded in
			
			blended_putpixel(bmp, x, Y, color, 1.0f - f);
			blended_putpixel(bmp, x, Y2, color, f);			

			y += d;
		}
	}
	else//steep slope
	{
		//clip the line to the bitmap
		//flip the points so the coords go bottom to top
		if(_y1 > _y2)
		{	
			x1 = _x2;
			x2 = _x1;
			y1 = _y2;
			y2 = _y1;
		}
		else
		{
			x1 = _x1;
			x2 = _x2;
			y1 = _y1;
			y2 = _y2;
		}

		int old_y1 = y1;
		int old_y2 = y2;
		//clip y coords
		if(y1 < 0)
			y1 = 0;
		if(y1 >= bmp->h)
			return;

		if(y2 < 0)
			return;
		if(y2 >= bmp->h)
			y2 = bmp->h;

		float d = float(dx) / float(dy);

		x1 = x1 + float(y1 - old_y1) * d;//new x's based on the clipped y's
		x2 = x2 + float(y2 - old_y2) * d;

		float x = x1;
		for(int y = y1; y < y2; y++)
		{
			int X = int(x);
			int X2 = X + 1;

			if(X < 0)
			{
				if(d < 0)
					break;
				x += d;
				continue;
			}
			if(X2 >= bmp->w)
			{
				if(d > 0)
					break;
				x += d;
				continue;
			}

			float f = fabs(x - X);

			blended_putpixel(bmp, X, y, color, 1.0f - f);
			blended_putpixel(bmp, X2, y, color, f);

			x += d;
		}
	}
}

//returns the pixel circumpherence of a circle(i.e. the number of pixels needed to draw the
//circumference)
int get_circle_circumference(int radius)
{
	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4

	if(int(sqrtf(radius * radius - end * end)) == end)
	{
		end --;
	}
	end++;
	return 8 * end + 1;
}

//gets the corrected index between two given indices(the index space is continuous, but
//the initial indices can be on opposite sides of the 0 degree point
//returns -1 if the index is out of bounds
//circ is the circumpherence of the whole circle
int get_correct_index(int idx, int idx1, int idx2, int circ)
{
	if(idx1 > idx2)//thus we pass through the discontinuity at 0 degrees
	{
		if(idx >= idx1 && idx <= circ)
			return idx - idx1;
		if(idx < idx1 && idx > idx2)
			return -1;
		return idx + (circ - idx1);
	}
	else
	{
		if(idx < idx1)
			return -1;
		if(idx > idx2)
			return -1;
		return idx - idx1;
	}
}

//gets the indices of the arc(used in the above function)
void get_arc_indicies(int radius, float _a1, float _a2, int* idx1, int* idx2)
{
	float a1 = _a2;
	float a2 = _a1;

	int	oct_to_check1 = int(a1 / AL_PI * 4.0f);
	int oct_to_check2 = int(a2 / AL_PI * 4.0f);

	int x1 = float(radius) * cosf(a1);
	int y1 = float(radius) * sinf(a1);
	int x2 = float(radius) * cosf(a2);
	int y2 = float(radius) * sinf(a2);

	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4

	if(int(sqrtf(radius * radius - end * end)) == end)
	{
		end --;
	}

	end += 1;

	int ret1, ret2;

	if(oct_to_check1 == 1 || oct_to_check1 == 2 || oct_to_check1 == 5 || oct_to_check1 == 6)
	{
		if(oct_to_check1%2 == 0)
		{
			ret1 = oct_to_check1 * end + abs(x1);
		}
		else
		{
			ret1 = (oct_to_check1 + 1) * end - abs(x1) - 1;
		}
	}
	else
	{
		if(oct_to_check1%2 == 0)
		{
			ret1 = oct_to_check1 * end + abs(y1);
		}
		else
		{
			ret1 = (oct_to_check1 + 1) * end - abs(y1) - 1;
		}
	}

	if(oct_to_check2 == 1 || oct_to_check2 == 2 || oct_to_check2 == 5 || oct_to_check2 == 6)
	{
		if(oct_to_check2%2 == 0)
		{
			ret2 = oct_to_check2 * end + abs(x2);
		}
		else
		{
			ret2 = (oct_to_check2 + 1) * end - abs(x2) - 1;
		}
	}
	else
	{
		if(oct_to_check2%2 == 0)
		{
			ret2 = oct_to_check2 * end + abs(y2);
		}
		else
		{
			ret2 = (oct_to_check2 + 1) * end - abs(y2) - 1;
		}
	}
	*idx1 = ret1;
	*idx2 = ret2;
}

//draws a continuous arc(an arc such that when the two arcs with their radii differing by 1 have 
//no spaces between them

void cont_arc(BITMAP* bmp, int _x, int _y, int radius, float _a1, float _a2, void* ptr, 
			  void (*proc) (BITMAP* bmp, int x, int y, int idx, void* ptr, bool on_arc))
{
//x, y, index, on_arc
#undef _PIXEL
#define _PIXEL(a,b,c,d)											\
	{															\
	__x = a + _x; __y = b + _y;									\
	if(__x < bmp->w && __y < bmp->h && __x > -1 && __y > -1)	\
	{															\
		proc(bmp, __x, __y, c, ptr, d);							\
	}															\
	}															\


#define OCT0	1
#define OCT1	2
#define OCT2	4
#define OCT3	8
#define OCT4	16
#define OCT5	32
#define OCT6	64
#define OCT7	128

	int octant_flags = 0;
	int oct_to_check1 = 0;
	int oct_to_check2 = 0;

	//determine which octants are affected
	float a1 = _a2;
	float a2 = _a1;

	oct_to_check1 = int(a1 / AL_PI * 4.0f);
	oct_to_check2 = int(a2 / AL_PI * 4.0f);

	int oct = oct_to_check2;
	octant_flags |= 1 << oct;
	while(oct != oct_to_check1)
	{
		oct++;
		oct %= 8;
		octant_flags |= 1 << oct;	
	}

	bool hack = false;
	if(oct_to_check1 == oct_to_check2 && _a1 > _a2)//a hack, prevents a bug for highly obstuse angles
	{
		hack = true;
		octant_flags |= 255;
	}

	//perhaps I should just make another fn for this? probably is the fastest way...

	//2 defines, one for x and one for y
	//also specify direction

	int x1 = float(radius) * cosf(a1);
	int y1 = float(radius) * sinf(a1);
	int x2 = float(radius) * cosf(a2);
	int y2 = float(radius) * sinf(a2);

	float r2 = float(radius);
	r2 *= r2;
	float r3 = float(radius - 1);
	r3 *= r3;

	int end = 0.707106781 * float(radius);//starting from pi/2 and going right to pi/4
	bool needed = true;

	int end2 = (int)((0.707106781 * float(radius) + .29));//no idea why .29 works...
	if(end2 != end)
		needed = false;
	if(int(sqrtf(r2 - end * end)) == end)
	{
		end --;
	}
	
	int idx_delta = end + 1;

	if(!hack)
	{
	for(int x = 0; x <= end; x++)
	{
		int Y = int(sqrtf(r2 - x * x));
		int Y2 = int(sqrtf(r3 - x * x));
		int __x, __y;//, __x2, __y2;

		for(int y = Y; y > Y2; y--)
		{
			if(x == y)
				continue;
			bool on = y == Y;
			int u = x;
			if(octant_flags & OCT1)
			{
				if(!(oct_to_check1 == 1 && u < x1) && !(oct_to_check2 == 1 && u > x2))
					_PIXEL(x, y, -x + 2 * idx_delta - 1, on);
			}
			if(octant_flags & OCT0 && x != 0)
			{
				if(!(oct_to_check1 == 0 && u > y1) && !(oct_to_check2 == 0 && u < y2))
					_PIXEL(y, x, x, on);
			}

			u = -x;
			if(octant_flags & OCT2 && x != 0 )
			{
				if(!(oct_to_check1 == 2 && u < x1) && !(oct_to_check2 == 2 && u > x2))
					_PIXEL(-x, y, x + 2 * idx_delta, on);
			}
			if(octant_flags & OCT7)
			{
				if(!(oct_to_check1 == 7 && u > y1) && !(oct_to_check2 == 7 && u < y2))
					_PIXEL(y, -x, 8 * idx_delta - x - 1, on);
			}

			u = x;
			//v = -Y;
			if(octant_flags & OCT6 && x != 0)
			{
				if(!(oct_to_check1 == 6 && u > x1) && !(oct_to_check2 == 6 && u < x2))
				{
					_PIXEL(x, -y, x + 6 * idx_delta, on);
				}
			}
			if(octant_flags & OCT3)
			{
				if(!(oct_to_check1 == 3 && u < y1) && !(oct_to_check2 == 3 && u > y2))
					_PIXEL(-y, x, 4 * idx_delta - x - 1, on);
			}

			u = -x;
			if(octant_flags & OCT5)
			{
				if(!(oct_to_check1 == 5 && u > x1) && !(oct_to_check2 == 5 && u < x2))
					_PIXEL(-x, -y, 6 * idx_delta - x, on);
			}
			if(octant_flags & OCT4 && x != 0)
			{
				if(!(oct_to_check1 == 4 && u < y1) && !(oct_to_check2 == 4 && u > y2))
					_PIXEL(-y, -x, 4 * idx_delta + x, on);
			}
		}
	}
	int __x, __y;//, __x2, __y2;
	if(needed)
	{	
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && end2 > y1) && !(oct_to_check2 == 0 && end2 < y2))
				_PIXEL(end2, end2, idx_delta - 0, true);
		}
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && -end2 < x1) && !(oct_to_check2 == 2 && -end2 > x2))
				_PIXEL(-end2, end2, 3 * idx_delta - 0, true);
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && -end2 < y1) && !(oct_to_check2 == 4 && -end2 > y2))
				_PIXEL(-end2, -end2, 5 * idx_delta - 0, true);
		}
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && end2 > x1) && !(oct_to_check2 == 6 && end2 < x2))
				_PIXEL(end2, -end2, 7 * idx_delta - 0, true);
		}
	}
	}
	else//hack
	{
	for(int x = 0; x <= end; x++)
	{
		int Y = int(sqrtf(r2 - x * x));
		int Y2 = int(sqrtf(r3 - x * x));
		int __x, __y;//, __x2, __y2;

		for(int y = Y; y > Y2; y--)
		{
			if(x == y)
				continue;
			bool on = y == Y;
			int u = x;
			if(octant_flags & OCT1)
			{
				if(!(oct_to_check1 == 1 && u < x1) || !(oct_to_check2 == 1 && u > x2))
					_PIXEL(x, y, -x + 2 * idx_delta - 1, on);
			}
			if(octant_flags & OCT0 && x != 0)
			{
				if(!(oct_to_check1 == 0 && u > y1) || !(oct_to_check2 == 0 && u < y2))
					_PIXEL(y, x, x, on);
			}

			u = -x;
			if(octant_flags & OCT2 && x != 0 )
			{
				if(!(oct_to_check1 == 2 && u < x1) || !(oct_to_check2 == 2 && u > x2))
					_PIXEL(-x, y, x + 2 * idx_delta, on);
			}
			if(octant_flags & OCT7)
			{
				if(!(oct_to_check1 == 7 && u > y1) || !(oct_to_check2 == 7 && u < y2))
					_PIXEL(y, -x, 8 * idx_delta - x - 1, on);
			}

			u = x;
			//v = -Y;
			if(octant_flags & OCT6 && x != 0)
			{
				if(!(oct_to_check1 == 6 && u > x1) || !(oct_to_check2 == 6 && u < x2))
				{
					_PIXEL(x, -y, x + 6 * idx_delta, on);
				}
			}
			if(octant_flags & OCT3)
			{
				if(!(oct_to_check1 == 3 && u < y1) || !(oct_to_check2 == 3 && u > y2))
					_PIXEL(-y, x, 4 * idx_delta - x - 1, on);
			}

			u = -x;
			if(octant_flags & OCT5)
			{
				if(!(oct_to_check1 == 5 && u > x1) || !(oct_to_check2 == 5 && u < x2))
					_PIXEL(-x, -y, 6 * idx_delta - x, on);
			}
			if(octant_flags & OCT4 && x != 0)
			{
				if(!(oct_to_check1 == 4 && u < y1) || !(oct_to_check2 == 4 && u > y2))
					_PIXEL(-y, -x, 4 * idx_delta + x, on);
			}
		}
	}
	int __x, __y;//, __x2, __y2;
	if(needed)
	{	
		if(octant_flags & OCT0)
		{
			if(!(oct_to_check1 == 0 && end2 > y1) || !(oct_to_check2 == 0 && end2 < y2))
				_PIXEL(end2, end2, idx_delta - 0, true);
		}
		if(octant_flags & OCT2)
		{
			if(!(oct_to_check1 == 2 && -end2 < x1) || !(oct_to_check2 == 2 && -end2 > x2))
				_PIXEL(-end2, end2, 3 * idx_delta - 0, true);
		}
		if(octant_flags & OCT4)
		{
			if(!(oct_to_check1 == 4 && -end2 < y1) || !(oct_to_check2 == 4 && -end2 > y2))
				_PIXEL(-end2, -end2, 5 * idx_delta - 0, true);
		}
		if(octant_flags & OCT6)
		{
			if(!(oct_to_check1 == 6 && end2 > x1) || !(oct_to_check2 == 6 && end2 < x2))
				_PIXEL(end2, -end2, 7 * idx_delta - 0, true);
		}
	}
	}
}

//draws the progress spiral
void DrawProgress(float factor, const char* text, const char* text2)
{
	int num = factor * 20;

	//the coordinates of the circles(20 in all)
	int coords[][2] = 
	{
		{50, 0},
		{18, 56},
		{-46, 49},
		{-76, -8},
		{-50, -68},
		{9, -93},
		{71, -73},
		{109, -21},
		{111, 44},
		{80, 100},
		{24, 135},
		{-39, 140},
		{-100, 117},
		{-146, 71},
		{-171, 11},
		{-171, -53},
		{-149, -114},
		{-108, -164},
		{-53, -198},
		{8, -213}
	};

	int color = factor > 1.0f ? 100 : 80;//white when the progress is finished

	for(int ii = 0; ii < 20; ii++)//loop throught the circles and draw them
	{
		int x = coords[ii][0] + SCREEN_W / 2;
		int y = coords[ii][1] + SCREEN_H / 2;

		circlefill(GetDrawPage(), x, y, 15, 50);
		circlefill(GetDrawPage(), x, y, 13, 0);

		aa_circle(GetDrawPage(), x, y, 13, 50);
		aa_circle(GetDrawPage(), x, y, 15, 50);

		if(ii < num)//these represent the filled in circles
		{
			circlefill(GetDrawPage(), x, y, 10, color);
			aa_circle(GetDrawPage(), x, y, 10, color);
		}
	}

	textout_centre_ex(GetDrawPage(), font, text, SCREEN_W / 2, SCREEN_H / 2 + 200, 80, 0);
	textout_centre_ex(GetDrawPage(), font, text2, SCREEN_W / 2, 50, 80, 0);

	release_bitmap(GetDrawPage());

	ShowPage();
}

inline int Max(int a, int b)
{
	return a > b ? a : b;
}

//creates a colour map for drawing subspcae
//basically it is a half transparent overlay, with stepped filter on the subspace bitmap
void CreateSubSpaceMap(COLOR_MAP& cmap, float darkening, int num_steps, int max_col)
{
	int step = max_col / num_steps;
	for(int ii = 0; ii < 256; ii++)
	{
		for(int jj = 0; jj < 256; jj++)
		{
			int res = jj * darkening + int(ii / step) * step;
			if(res > max_col)
				res = max_col;
			cmap.data[ii][jj] = res;
		}
	}
}

//a simple saturated addtion map
void CreateAdditionMap(COLOR_MAP& cmap, int max_col)
{
	for(int ii = 0; ii < 256; ii++)
	{
		for(int jj = 0; jj < 256; jj++)
		{
			int res = ii + jj;
			if(res > max_col)
				res = max_col;
			cmap.data[ii][jj] = res;
		}
	}
}

//a simple subtraction map
void CreateSubtractionMap(COLOR_MAP& cmap)
{
	for(int ii = 0; ii < 256; ii++)
	{
		for(int jj = 0; jj < 256; jj++)
		{
			int res = jj - ii;
			if(res < 0)
				res = 0;
			cmap.data[ii][jj] = res;
		}
	}
}

//creates an inverse map
void CreateInverseMap(COLOR_MAP& cmap)
{
	for(int ii = 0; ii < 256; ii++)
	{
		for(int jj = 0; jj < 256; jj++)
		{
			int res = 255 - jj + ii;
			if(res > 255)
				res = 255;
			if(res < 0)
				res = 0;
			cmap.data[ii][jj] = res;
		}
	}
}
