//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//types.h
//defines a lot of the structs used in game

#pragma once

#include "allegro.h"
#include "math.h"

//#ifdef __cplusplus
//
//extern "C"
//{
//
//#endif
//
//#include "enet/enet.h"
//
//#ifdef __cplusplus
//
//}
//
//#endif

#include <vector>
#include <string>
#include <list>

using namespace std;

#define _GALAXY_RADIUS 1024
#define _GALAXY_THUMB_SIZE 128

//number of bombs to spawn in a burst/explosion
#define _BOMB_NUMBER 50
//how long a bomb lasts
#define _BOMB_LIFE 5000

//the global time variable
extern volatile int g_nTime;

//random things
#define _NUM_SEEDS 20
extern int g_nSeed;
extern int g_nStartPoint;
extern float rande();

//just needed to make the code compile
struct ENetPeer;

//some network package types
enum
{
	_HELLO_PACKAGE, //name
	_INI_RESPONSE	//player num
};

//used for network stuff
struct SPlayer
{
	bool active;
	string name;
};

//contains data to start a game
struct SMissionProfile
{
	vector<SPlayer> players;//will be used for networking
	int num_bots;//number of bots in this mission
	string mission_name;//mission name
	int player_num;//number of the player
	int ntype;//network type: 0 - single, 1 - server, 2 - client
};

//gui button
struct SButton
{
	int dummy;//used to tell whether the button is the last one or not(somewhat primitive...)

	//position
	int x;
	int y;

	//width and height
	int w;
	int h;

	//bitmaps associated with this
	BITMAP* bmp_idle;
	BITMAP* bmp_high;
	BITMAP* bmp_down;

	int (*fn)();//function to call when pressed

	const char* text;//text to draw on the button
	int align;//aligment of the text
};

//a point
struct SPoint
{
	int x;
	int y;
};

//the planet struct
struct SPlanet
{
	//position
	int x;
	int y;
	//the state of the planet(to do next turn)
	int state;

	int num_generators;
	int num_shields;

	//various state parameters
	int state_x;
	int state_y;

	float state_val1;
	float state_val2;
	float state_val3;
	float state_val4;

	int energy;			//energy reserves
	int energy_left;	//energy left in the surrounding space

	int shield;			//shield level

	bool dead;			//are we dead?

	bool done;			//are we done with planning?

	string name;		//name of the planet

	int score;			//score of the planet

	int last_hit_by;	//the index of the planet who last hit us

	int race;			//race of the planet

	bool ai;			//is this an ai planet?

	SPlanet()
	{
		x = y = 0;
		ai = false;
		num_generators = 1;
		num_shields = 1;
		energy = 10000;
		energy_left = 0;
		state_val3 = 10000;
		state_val4 = 0;
		state = -1;
		shield = 1000;
		dead = false;
		done = false;
		name.assign("Bot");
		score = 0;
		last_hit_by = -1;
	}
};

//the wave struct
struct SWave
{
	int energy;		//energy of the wave
	//angles that define the wave(always positive)
	float angle1;//start angle
	float angle2;//end angle
	int radius;//radius of the wave

	//position of the wave
	int x;
	int y;
	vector<float> energies;//energies buffer
	bool subspace;//is this a subspace wave?
	int source;//who launched it
};

//npc struct
struct SNPC
{
	//initial position
	float x;
	float y;
	float theta;//theta
	int type;//type of the npc: 0 - battle pod, 1 - bounty circle

	//various data... perhaps a good place to use some polymorphism... maybe later
	int val1;
	int val2;
	int val3;
	int val4;
	int val5;

	SNPC()
	{
		memset(this, 0, sizeof(SNPC));
	}
};

//the particle struct
struct SParticle
{
	BITMAP* bmp;//the particle bitmap
	//particle location
	int x;
	int y;
	int life;//particle life

	SParticle()
	{
		x = 0;
		y = 0;
		life = 0;
	}
};

//the bomb struct
struct SBomb
{
	int x;
	int y;
	float life;
	int radius;
	float theta;
	int wait;
	bool parent;
	bool subspace;
	int energy;
	int source;//who launched it
};

//action parameter (used in the game.cpp)
struct ActionParam
{
	vector<SPlanet> *planets;
	list<SWave> *waves;
	list<SParticle> *particles;
	list<SBomb> *bombs;
	list<SNPC> *npcs;
	BITMAP* galaxy;
	BITMAP* subspace;
	BITMAP* flash[5];
	int* total_turn;
	int player;
};


//datafile stuff
extern DATAFILE* g_pData;

#define _Button                           0        /* SAMP */
#define _Death                            1        /* SAMP */
#define _End                              2        /* SAMP */
#define _Generator                        3        /* SAMP */
#define _Mouse                            4        /* BMP  */
#define _Shield_hit                       5        /* SAMP */
#define _Start_turn                       6        /* SAMP */
#define _Teleport                         7        /* SAMP */
#define _Title                            8        /* BMP  */
#define _Wave                             9        /* SAMP */
#define _Wave2                            10       /* SAMP */
#define _Shield_up                        11       /* SAMP */
#define _Chat                             12       /* SAMP */
#define _Cannon1                          13       /* SAMP */
#define _Cannon2                          14       /* SAMP */
#define _Cannon3                          15       /* SAMP */
#define _Burst                            16       /* SAMP */
#define _Npc_launch                       17       /* SAMP */
#define _Npc_fire                         18       /* SAMP */
#define _Npc_death                        19       /* SAMP */
