//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//planet.cpp
//handles some planet tricks

#include "planet.h"

//the following are used for the limited teleport integrator
int g_nTeleportTempVar;//holds the cost of the line(limited by the max energy)
int g_nTeleportTempX;//holds the last allowable point(limited by the max energy)
int g_nTeleportTempY;

//a primitive line integrator
//it will add the cost of the current pixel to the tempvar
//the d parameter signifies how much energy is available for this
void TeleportIntergatorLim(BITMAP* bmp, int x, int y, int d)
{
	if(x < 0 || y < 0 || x > bmp->w - 1 || y > bmp->h - 1)
		return;
	int val = 5 * (100 - _getpixel(bmp, x, y));
	if(g_nTeleportTempVar + val < d)
	{
		g_nTeleportTempX = x;
		g_nTeleportTempY = y;
		g_nTeleportTempVar += val;
	}	
}

//increase weapon power
void IncreaseWavePower(SPlanet* planet)
{
	planet->state_val3 += 10000;
}

//decrease weapon power
void DecreaseWavePower(SPlanet* planet)
{
	planet->state_val3 -= 10000;
	if(planet->state_val3 <= 10000)
		planet->state_val3 = 10000;
}

//returns weapon power
int GetWavePower(SPlanet* planet)
{
	if(planet->state == 1 || planet->state == 2)
	{
		return planet->state_val3;
	}
	else
		return 0;
}

//integrates the movement cost(based on subspace) on a line
//energy represents the max energy available
//xout and yout give the farthest point it could go
//return is the actual energy expenditure
int GetMoveCost(int x1, int y1, int x2, int y2, int energy, int *xout, int *yout, BITMAP* subspace)
{
	g_nTeleportTempVar = 0;
	g_nTeleportTempX = x1;
	g_nTeleportTempY = x2;

	do_line(subspace, x1, y1, 
	x2, y2, energy, TeleportIntergatorLim);
	
	if(xout && yout)
	{
		*xout = g_nTeleportTempX;
		*yout = g_nTeleportTempY;
	}
	return g_nTeleportTempVar;
}

//set the move state
void SetMoveState(SPlanet* planet, int dest_x, int dest_y, BITMAP* subspace)
{
	planet->state_x = dest_x;
	planet->state_y = dest_y;
	planet->state = 0;//move state

	//put the energy needed into val4
	//the state x and y will hold the allowable position
	planet->state_val4 = GetMoveCost(planet->x, planet->y, planet->state_x, planet->state_y, 
		planet->energy, &planet->state_x, &planet->state_y, subspace);
}

//set the generator state
void SetGeneratorState(SPlanet* planet)
{
	planet->state = 3;
	planet->state_val4 = planet->num_generators * 20000;
}

//set the generator state
void SetShieldState(SPlanet* planet)
{
	planet->state = 4;
	planet->state_val4 = planet->num_shields * 20000;
}

//initializes thw wave state
//we mostly get the initial direction vector
void SetIniWaveState(SPlanet* planet, int dest_x, int dest_y, bool subspace)
{
	planet->state_x = dest_x;
	planet->state_y = dest_y;
	planet->state = 1;
	if(subspace)
		planet->state = 2;
}

//now that we know the direction vector, we can figure out the angular size
void SetWaveState(SPlanet* planet, int dest_x, int dest_y)
{
	float a,b,c,d;

	a = dest_x - planet->x;//vector from planet to the mouse
	b = dest_y - planet->y;

	c = planet->state_x - planet->x;//vector from planet to the intial 
	d = planet->state_y - planet->y;
	
	//dot product of the two vectors divided by the magnitudes of the two vectors
	float factor = (a * c + b * d) / sqrt((a * a + b * b) * (c * c + d * d));

	float dangle = fabs(acosf(factor));//and now we know the deflection angle
	
	float angle = atan2f(d, c);//the direction angle

	planet->state_val1 = angle - dangle;
	
	//we need this positive
	if(planet->state_val1 < 0)
		planet->state_val1 += 2 * AL_PI;
	if(planet->state_val1 > 2 * AL_PI)
		planet->state_val1 -= 2 * AL_PI;

	planet->state_val2 = angle + dangle;
	
	//we need this positive
	if(planet->state_val2 < 0)
		planet->state_val2 += 2 * AL_PI;
	if(planet->state_val2 > 2 * AL_PI)
		planet->state_val2 -= 2 * AL_PI;
}

//a similar function to the above, except now we know the dangle
void SetWaveState(SPlanet* planet, float dangle)
{
	float c,d;

	c = planet->state_x - planet->x;
	d = planet->state_y - planet->y;
		
	float angle = atan2f(d, c);

	planet->state_val1 = angle - dangle;
	if(planet->state_val1 < 0)
		planet->state_val1 += 2 * AL_PI;
	if(planet->state_val1 > 2 * AL_PI)
		planet->state_val1 -= 2 * AL_PI;

	planet->state_val2 = angle + dangle;
	if(planet->state_val2 < 0)
		planet->state_val2 += 2 * AL_PI;
	if(planet->state_val2 > 2 * AL_PI)
		planet->state_val2 -= 2 * AL_PI;
}

//set initial burst state(analogous to the wave function)
void SetIniBurstState(SPlanet* planet, int dest_x, int dest_y, bool subspace)
{
	planet->state_x = dest_x;
	planet->state_y = dest_y;
	planet->state = 1;
	if(subspace)
		planet->state = 2;
}

//set the secondary burst state stuff
void SetBurstState(SPlanet* planet, int dest_x, int dest_y)
{
	float a,b,c,d;

	a = dest_x - planet->x;
	b = dest_y - planet->y;
	c = planet->state_x - planet->x;
	d = planet->state_y - planet->y;
	
	float factor = (a * c + b * d) / sqrt((a * a + b * b) * (c * c + d * d));

	float dangle = fabs(acosf(factor));
	
	float angle = atan2f(d, c);

	//unlike the wave, we care more about the non-added values
	planet->state_val1 = angle;
	planet->state_val2 = dangle;
}

//a similar function to the above, but now we know the dangle
void SetBurstState(SPlanet* planet, float dangle)
{
	float c,d;

	c = planet->state_x - planet->x;
	d = planet->state_y - planet->y;
	
	float angle = atan2f(d, c);

	planet->state_val1 = angle;
	planet->state_val2 = dangle;
}

//there is no material difference between a pod state and a bomb state
void SetPodState(SPlanet* planet, int dest_x, int dest_y, BITMAP* subspace)
{
	SetBombState(planet, dest_x, dest_y, false, subspace);
}

//sets the bomb state
//we input the desired target, but then adjust it to match the actual energy reserves
void SetBombState(SPlanet* planet, int dest_x, int dest_y, bool sub, BITMAP* subspace)
{
	float c,d;

	c = dest_x - planet->x;
	d = dest_y - planet->y;

	float angle = atan2f(d, c);

	planet->state_val1 = angle;

	int energy = planet->state_val3 > planet->energy ? planet->energy : planet->state_val3;

	energy /= 2;//no idea why(could this be a bug?)

	planet->state_val2 = GetMoveCost(planet->x, planet->y, dest_x, dest_y, energy, &planet->state_x,
		&planet->state_y, subspace);

	planet->state = 1;
	if(sub)
		planet->state = 2;
}
