//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//network.h

#include "types.h"

struct SPacket
{
	int type;
	int data_len;
	void* data;
};

struct SPeerData
{
	int player_num;
};

extern int InitNetwork();
extern void DeInitNetwork();

extern int StartServer(const char* ip_address);
extern int StartClient();

extern int Connect(const char* ip_address);
extern void DestroyHost();

extern int HandleNetwork(SPacket** packet, ENetPeer ** peer);

extern void BroadcastPacket(SPacket* packet);
extern void SendPacket(ENetPeer* peer, SPacket* packet);
