//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//main.cpp
//houses the main function

#include "types.h"
#include "menu.h"
#include "palette.h"
#include "network.h"
#include "mouse.h"
#include "gfx.h"
#include "game.h"
#include "input_functions.h"

bool g_bQuit = false;//used for the quit button

extern int g_nChatSize;
extern int g_nPlayerRace;
extern int g_nGameType;
extern int g_nMaxPoints;
extern float g_fDamageMultiplier;
extern int g_nNumComputerPlayers;

DATAFILE* g_pData;//the data for the game

void ExitCallback()
{	
	g_bQuit = true;
};

volatile int g_nTime = 0;//the time, used for timing purposes

void increment_time()
{
    g_nTime++;
}

END_OF_FUNCTION(increment_time)

int main()
{
	LOCK_VARIABLE(g_nTime);
	LOCK_FUNCTION(increment_time);

	//initialize allegro	
	if (allegro_init() != 0)
		return 1;

	if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) != 0)
	{
		allegro_message("Error initialising sound system\n%s\n", allegro_error);
		return 1;
	}

	set_close_button_callback(ExitCallback);

	set_color_depth(8);

	int x, y;
	int full;

	//load settings file
	set_config_file("settings.ini");

	x = get_config_int("", "xres", 800);
	y = get_config_int("", "yres", 600);
	full = get_config_int("", "fullscreen", 0);

	g_nChatSize = 0;
	SetPlayerName(get_config_string("", "name", "Player"));
	g_nChatSize = get_config_int("", "chat", 0) % 4;
	g_nPlayerRace = get_config_int("", "race", 0);
	g_nGameType = get_config_int("", "gametype", 0);
	g_nMaxPoints = get_config_int("", "maxscore", 5);
	g_nNumComputerPlayers = get_config_int("", "bots", 0);

	if(g_nMaxPoints < 5)
		g_nMaxPoints = 5;

	g_fDamageMultiplier = get_config_float("", "damage_x", 1.0f);

	//initialize the graphics mode
	if(full)
	{
		if(set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, x, y, 0, 0) != 0)
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
			return 1;
		}
	}
	else
	{
		if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, x, y, 0, 0) != 0)
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message("Unable to set any graphic mode\n%s\n", allegro_error);
			return 1;
		}
	}

	//initialise the graphics routines
	if(!InitGfx())
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to initialize graphics mode\n%s\n", allegro_error);
		return 1;
	}

	//some more installations
	install_keyboard();
	install_mouse();
	install_timer();

	install_int_ex(increment_time, BPS_TO_TIMER(50));

	g_pData = load_datafile("data.dat");//load the main datafiles
	if(g_pData == 0)
	{
		set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
		allegro_message("Unable to load main data file\n%s\n", allegro_error);
		return 1;
	}

	//load the palettes
	LoadPalettes();

	//init stuff
	InitMouse();
	InitMenu();
	InitNetwork();

	//the root loop of the game
	while(!g_bQuit)
	{
		SMissionProfile profile;
		int ret = DoMenu(&profile);//start the menu
		if(ret < 0)//if the user selected something drastic
		{
			switch(ret)
			{
			case -1:
				g_bQuit = true;
				break;
			case -2:
_RESTART:;
				if(RunGame(&profile) != 0)
					goto _RESTART;//I LOVE GOTO
				break;
			}
		}

		DrawMouse();
		ShowPage();
		UpdateInput();
	}

	//save the settings
	set_config_file("settings.ini");
	SavePaletteChanges();

	set_config_string("", "name", GetPlayerName());
	set_config_int("", "chat", g_nChatSize);
	set_config_int("", "race", g_nPlayerRace);
	set_config_int("", "gametype", g_nGameType);
	set_config_int("", "maxscore", g_nMaxPoints);
	set_config_float("", "damage_x", g_fDamageMultiplier);
	set_config_int("", "bots", g_nNumComputerPlayers);

	unload_datafile(g_pData);//unload the datafile

	//deinit stuff
	DeInitMenu();
	DeInitMouse();
	DeInitNetwork();

	return 1;
}
END_OF_MAIN()
