//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//input_functions.cpp
//Handles the input routines
//This uses keyboard polling through allegro's key system
//I do not use the silly event system because it cannot handle the loss of focus very well



#include "input_functions.h"
#include "allegro.h"

//The Key States:
//-1 = just released
//0 = up
//1 = down
//2 = just pressed
int g_nKeyStates[KEY_MAX];
int g_nMouseStates[3];

int g_nMouseX;
int g_nMouseY;
int g_nMouseDZ;//we only store the change in the mouse wheel's position

//updates input, and stores the new key states
void UpdateInput()
{
	poll_mouse();
	poll_keyboard();

	int pos = mouse_pos;

	g_nMouseX = pos >> 16; 
	g_nMouseY = pos & 0x0000ffff;

	g_nMouseDZ = mouse_z;

	position_mouse_z(0);

	int buttons = mouse_b;

	//mouse stuff
	for(int ii = 0; ii < 3; ii++)
	{
		int n = 1 << ii;
		if(buttons & n)
		{
			switch(g_nMouseStates[ii])
			{
			case -1:
				g_nMouseStates[ii] = 2;
				break;
			case 0:
				g_nMouseStates[ii] = 2;
				break;
			case 1:
				//g_nKeyStates[ii] = 1;
				break;
			case 2:
				g_nMouseStates[ii] = 1;
				break;
			default://init purposes
				g_nMouseStates[ii] = 0;
				break;
			}
		}
		else
		{
			switch(g_nMouseStates[ii])
			{
			case -1:
				g_nMouseStates[ii] = 0;
				break;
			case 0:
				//g_nKeyStates[ii] = 0;
				break;
			case 1:
				g_nMouseStates[ii] = -1;
				break;
			case 2:
				g_nMouseStates[ii] = -1;
				break;
			default://init purposes
				g_nMouseStates[ii] = 0;
				break;
			}
		}
	}

	//keyboard stuff
	for(int ii = 0; ii < KEY_MAX; ii++)
	{
		if(key[ii])
		{
			switch(g_nKeyStates[ii])
			{
			case -1:
				g_nKeyStates[ii] = 2;
				break;
			case 0:
				g_nKeyStates[ii] = 2;
				break;
			case 1:
				//g_nKeyStates[ii] = 1;
				break;
			case 2:
				g_nKeyStates[ii] = 1;
				break;
			default://init purposes
				g_nKeyStates[ii] = 0;
				break;
			}
		}
		else
		{
			switch(g_nKeyStates[ii])
			{
			case -1:
				g_nKeyStates[ii] = 0;
				break;
			case 0:
				//g_nKeyStates[ii] = 0;
				break;
			case 1:
				g_nKeyStates[ii] = -1;
				break;
			case 2:
				g_nKeyStates[ii] = -1;
				break;
			default://init purposes
				g_nKeyStates[ii] = 0;
				break;
			}
		}
	}
}

//Again, for reference:
//-1 = just released
//0 = up
//1 = down
//2 = just pressed

bool IsKeyJustPressed(int n)
{
	return g_nKeyStates[n] == 2;
}
bool IsKeyDown(int n)
{
	return g_nKeyStates[n] > 0;
}
bool IsKeyJustReleased(int n)
{
	return g_nKeyStates[n] == -1;
}
bool IsKeyUp(int n)
{
	return g_nKeyStates[n] < 1;
}

//mouse stuff
bool IsMKeyJustPressed(int n)
{
	return g_nMouseStates[n] == 2;
}
bool IsMKeyDown(int n)
{
	return g_nMouseStates[n] > 0;
}
bool IsMKeyJustReleased(int n)
{
	return g_nMouseStates[n] == -1;
}
bool IsMKeyUp(int n)
{
	return g_nMouseStates[n] < 1;
}

bool IsCtrlDown()
{
	return IsKeyDown(KEY_LCONTROL) || IsKeyDown(KEY_RCONTROL);
}

bool IsShiftDown()
{
	return IsKeyDown(KEY_LSHIFT) || IsKeyDown(KEY_RSHIFT);
}

bool IsAltDown()
{
	return IsKeyDown(KEY_ALT) || IsKeyDown(KEY_ALTGR);
}

void GetMousePos(int* x, int* y)
{
	*x = g_nMouseX;
	*y = g_nMouseY;
}

int GetMouseDZ()
{
	return g_nMouseDZ;
}
