//This file is part of Future's End
//Copyright 2006-2008 SiegeLord
//See license.txt for distribution information
//
//bomb.cpp
//Handles the bombs


#include "bomb.h"
#include "gfx.h"
#include "sound.h"

extern float g_fDamageMultiplier;	//the global damage multiplier
extern int g_nGameType;				//game type

//this draws the bomb
void DrawBomb(SBomb* bomb, int view_x, int view_y)
{
	int x = float(bomb->radius) * cosf(bomb->theta) + bomb->x - view_x;
	int y = float(bomb->radius) * sinf(bomb->theta) + bomb->y - view_y;

	if(bomb->parent)
	{
		circlefill(GetDrawPage(), x, y, 2, 0);
		aa_circle(GetDrawPage(), x, y, 2, 110);
	}
	else
	{
		aa_circle(GetDrawPage(), x, y, 2, 110);
	}
}

//this destroys some stars at _x,_y within the radius...
//power increases the magnitude of the effect
void DestroyStars(BITMAP* galaxy, int _x, int _y, int radius, float power)
{
//a macro that destroys starts, the two paramters are the displacements
//in respect to the _x and _y
#define _DESTROY(a,b)\
	{																		\
	__x = _x + a; __y = _y + b;												\
	val = getpixel(galaxy, __x, __y);										\
	if(val > 0)																\
	{																		\
		val -= amt;															\
		if(val < 0)/*clamp at 0		*/										\
		{																	\
			val = 0;														\
		}																	\
		_putpixel(galaxy, __x, __y, val);									\
	}																		\
	}																		\
	
	float r2 = radius;
	r2 *= r2;

	float factor = 10.1f / (float(radius)) * power; //factor to determine how much stars to remove

	//standard circle iteration follows
	for(int x = 0; x < radius; x++)
	{
		float x2 = float(x);
		x2 *= x2;
		int dy = sqrt(r2 - x2);
		for(int y = 0; y <= dy; y++)
		{
			int __x, __y, val;
			float y2 = y;
			y2 *= y2;
			int amt = sqrtf(x2 + y2) * factor;//linear decrease in power
			_DESTROY(x,y);
			if(y != 0)
				_DESTROY(x,-y);
			if(x != 0)
			{
				_DESTROY(-x,y);
				if(y != 0)
					_DESTROY(-x, -y);
			}
		}
	}
}

//moves the bomb
void MoveBomb(vector<SPlanet>* planets, list<SNPC>* npcs, SBomb* bomb, BITMAP* galaxy, BITMAP* subspace)
{
	if(bomb->wait > 0)	//if the bomb is still waiting to be launched
						//we just decrement the counter and return	
	{
		bomb->wait--;
		return;
	}

	bomb->radius++;

	int x = float(bomb->radius) * cosf(bomb->theta) + bomb->x;
	int y = float(bomb->radius) * sinf(bomb->theta) + bomb->y;

	bomb->life -= 5 * (100 - _getpixel(subspace, x, y));	//bombs are attenuated by subspace

	if(!bomb->parent)	//i.e. it is the damaging kind
	{
		float power = float(bomb->life) / _BOMB_LIFE;//the less life the bomb has, the less power it has

		if(power > 0)
		{
			if(bomb->subspace)
				DestroyStars(subspace, x, y, 2, power);
			else
				DestroyStars(galaxy, x, y, 2, power);
		}
	}

	if(!bomb->subspace)
	{
		//loop through planets
		for(unsigned int ii = 0; ii < planets->size(); ii++)
		{
			SPlanet* planet = &((*planets)[ii]);
			float dx = planet->x - x;
			float dy = planet->y - y;
			if((dx * dx + dy * dy) < 9)	//radius of the bomb is 3
			{
				if(bomb->parent && (unsigned)bomb->source == ii)//don't want to kill the person who launched it
					continue;
				if(!bomb->parent && bomb->life > 0)//bomb is the damaging kind, and is alive
				{
					planet->last_hit_by = bomb->source;
					planet->shield -= g_fDamageMultiplier * float(bomb->life)
						/ _BOMB_LIFE * float(bomb->energy) / 20.0f;
					if(!planet->dead || planet->shield > 0)
						PlaySound((SAMPLE*)g_pData[_Shield_hit].dat, x, y, false);
				}
				bomb->life = 0;	//if the bomb was a parent, this would cause it to detonate
			}
		}
		if(g_nGameType == 1)	//bounty
		{
			//we loop through the npc's as well
			for(list<SNPC>::iterator it = npcs->begin(); it != npcs->end(); it++)
			{
				SNPC* npc = &(*it);
				if(npc->type != 1)//bounty circle
					continue;

				float dx = npc->x - x;
				float dy = npc->y - y;

				float dist = dx * dx + dy * dy;

				float rad = npc->val2 / 16 + 3;	//radius of the circle
				
				rad *= rad;

				if((dist < rad) && npc->val1 > 0)
				{
					(*planets)[bomb->source].score += npc->val1 / 100;
					npc->val1 = -999; //kills the npc
					bomb->life = 0;	//if the bomb was a parent, this would cause it to detonate
				}
			}
		}
	}
}
