/* Dgege */
#include <string.h>
#include "main.h"
#include "zcontrol.h"
#include "game.h"
#include "player.h"


PLAYER *create_player(int id) {
	PLAYER *Player = (PLAYER *)malloc(sizeof(PLAYER));

	if (!Player)
		return NULL;

	memset(Player, 0, sizeof(PLAYER));

	Player->hp = 65536;
	Player->maxhp = 65536;
	Player->id = id;
	Player->num_bombs = 25;
	Player->num_missiles = 0;
	Player->stat = 0;
	memset(Player->stat_timer, 0, sizeof(Player->stat_timer));

	return Player;
}

void destroy_player(PLAYER *p) {

	if (p) {
		destroy_control(p->control);
		free(p);
	}

	return;
}


void destroy_players(PLAYER *p) {

	PLAYER *next;

	while (p) {
		next = p->next;
		destroy_player(p);
		p = next;
	}

	return;
}


void player_deduct_hp(PLAYER *player, int hp) {
 if ((player->stat & PLAYER_STAT_INVULNERABLE) == 0) {
  player->hp -= hp;
  if (player->hp < 0) player->hp = 0;
 }
}

/* Hack the PLAYER struct directly. This is just a slow extra level of
   indirection.

void modify_player(PLAYER *P, char *N, CONTROL *C, int H, int MH,
                   CAMERA *CA, void *D, SPRITE *S) {
 P->control = C;
 P->hp = H;
 P->maxhp = MH;
 P->camera = CA;
 P->data = D;
 P->sprite = S;
}

void modify_player_control(PLAYER *P, CONTROL *C) {
 P->control = C;
}

void modify_player_hp(PLAYER *P, int H) {
 P->hp = H;
}

void modify_player_maxhp(PLAYER *P, int MH) {
 P->maxhp = MH;
}

void modify_player_camera(PLAYER *P, CAMERA *CA) {
 P->camera = CA;
}

void modify_player_data(PLAYER *P, void *D) {
 P->data = D;
}

void modify_player_id(PLAYER *P, int id) {
 P->id = id;
}
*/
