#include "main.h"
#include "zcontrol.h"
#include "options.h"
#include "log.h"



int player_control_device[N_PLAYERS] = {0, 0, 0, 0};

#define N_ANIMAL_RATES 4
#define DEF_ANIMAL_RATE 2
char *animal_rate_desc = "AnimalAbundance";
int animal_rate;
char *animal_rate_name[] = {"None", "Rare", "Moderate", "Profuse"};



#define N_EXPLOSION_SIZES 3
#define DEF_EXPLOSION_SIZE 1
char *explosion_size_desc = "Explosions";
int explosion_size;
char *explosion_size_name[] = {"Petty", "Conspicuous", "Titanic"};



#define N_RESOLUTIONS 4
#define DEF_RESOLUTION_ID 0
char *resolution_desc = "Resolution";
int resolution_id;
char *resolution_name[] = {"320x200",
                           "400x300",
                           "640x480",
                           "800x600"};
int resolution_w[] = {320, 400, 640, 800};
int resolution_h[] = {200, 300, 480, 600};



#define N_TEXTURING_IDS 2
#define DEF_TEXTURING_ID 1
char *texturing_desc = "Texturing";
int texturing_id;
char *texturing_name[] = {"Approximate", "Precise"};
int texturing_type[] = {POLYTYPE_ATEX, POLYTYPE_PTEX};



#define N_RIPPLE_QUALITIES 4
#define DEF_RIPPLE_QUALITY 2
char *ripple_quality_desc = "Ripples";
int ripple_quality;
char *ripple_quality_name[] = {"Off", "Blocky", "LessBlocky", "Smooth"};



void load_player_control_devices() {
 int p;

 int devices = 0;

 set_config_file("bomb.ini");

 for (p = 0; p < N_PLAYERS; p++) {
  player_control_device[p] = control_identify_device(
                            get_config_int(player_orig_name[p], "device_type", 0),
                            get_config_int(player_orig_name[p], "device_id", -1));

  devices |= player_control_device[p];
 }

 if (devices == 0) {

  player_control_device[0] = human_device;
  for (p = 1; p < N_PLAYERS; p++) player_control_device[p] = zig_ai_device;

 }
}



void save_player_control_devices() {
 int p;

 set_config_file("bomb.ini");

 for (p = 0; p < N_PLAYERS; p++) {
  set_config_int(player_orig_name[p], "device_type",
                                ControlDeviceType[player_control_device[p]]);

  if (ControlDeviceID[player_control_device[p]] >= 0) {
   set_config_int(player_orig_name[p], "device_id",
                                ControlDeviceID[player_control_device[p]]);
  } else {
   set_config_string(player_orig_name[p], "device_id", 0);
  }
 }
}



void load_options() {

 set_config_file("bomb.ini");
 animal_rate = get_config_int("game", "animal_abundance", DEF_ANIMAL_RATE);
 explosion_size = get_config_int("game", "explosion_size", DEF_EXPLOSION_SIZE);
 resolution_id = get_config_int("quality", "resolution", DEF_RESOLUTION_ID);
 texturing_id = get_config_int("quality", "texturing", DEF_TEXTURING_ID);
 ripple_quality = get_config_int("quality", "ripples", DEF_RIPPLE_QUALITY);

 if ((unsigned int)animal_rate >= N_ANIMAL_RATES) animal_rate = DEF_ANIMAL_RATE;
 if ((unsigned int)explosion_size >= N_EXPLOSION_SIZES) explosion_size = DEF_EXPLOSION_SIZE;
 if ((unsigned int)resolution_id >= N_RESOLUTIONS) resolution_id = DEF_RESOLUTION_ID;
 if ((unsigned int)texturing_id >= N_TEXTURING_IDS) texturing_id = DEF_TEXTURING_ID;
 if ((unsigned int)ripple_quality >= N_RIPPLE_QUALITIES) ripple_quality = DEF_RIPPLE_QUALITY;

 load_player_control_devices();
}



void save_options() {

	set_config_file("bomb.ini");
	set_config_int("game", "animal_abundance", animal_rate);
	set_config_int("game", "explosion_size", explosion_size);
	set_config_int("quality", "resolution", resolution_id);
	set_config_int("quality", "texturing", texturing_id);
	set_config_int("quality", "ripples", ripple_quality);

	save_player_control_devices();

	set_config_file("");          /* Flush config */
	set_config_file("bomb.ini");
}


const char *get_language() {

	set_config_file("bomb.ini");
	return languages[get_config_int("game", "language", 0)];
}
