/* entheh */

#include "main.h"
#include "menuproc.h"
#include "timeloop.h"
#include "sound2.h"



/* Sprite. dp points to a pointer to a bitmap, e.g.
   BITMAP *logo;
   dp = &logo;
   ...
   logo = dat[GAME_LOGO].dat;
   ...
   draw_sprite(..., *(BITMAP **)dp, ...);
   ...
*/

/*
void md_sprite(BITMAP *bmp, BOMB_MENU *entry, int selected) {
 draw_sprite(bmp, *(BITMAP **)entry->dp, entry->x, entry->y);
}
*/


/* md_marquee()  displays a scrolling marquee 
 *  dp is the text, k is used internally. Set it to 0 initially.
 */
void md_marquee(BITMAP *bmp, BOMB_MENU *entry, int selected) {

	unsigned char *text = entry->dp;

	(void)selected;

	if (entry->k == 0)
		entry->k = game_time;

#ifndef ZIG_GL
	textout(bmp, MenuFont, text, SCREEN_W - (game_time - entry->k) + entry->x, entry->y, entry->d);	
#else
#endif
}


/* Text output. dp points to the string.
   d is the colour when not selected - don't choose white for an option!
   When selected, the text appears white.
*/
void md_text(BITMAP *bmp, BOMB_MENU *entry, int selected) {

#ifndef ZIG_GL
	rect(bmp, entry->x - 1, entry->y - 1, entry->x + text_length(MenuFont, entry->dp),
		entry->y + text_height(MenuFont), selected ? makecol(255, 255, 0) : 0);

	textout(bmp, MenuFont, entry->dp,
		entry->x, entry->y, selected ? COLOUR_WHITE : entry->d);
#else
#endif
}

void md_text_centre(BITMAP *bmp, BOMB_MENU *entry, int selected) {

#ifndef ZIG_GL
	int w = text_length(MenuFont, entry->dp);
	rect(bmp, entry->x - w/2 - 1, entry->y - 1, entry->x + w/2 + 1,
		entry->y + text_height(MenuFont), selected ? makecol(255, 255, 0) : 0);

	textout_centre(bmp, MenuFont, entry->dp,
		entry->x, entry->y, selected ? COLOUR_WHITE : entry->d);
#else
#endif
}

void md_text_right(BITMAP *bmp, BOMB_MENU *entry, int selected) {

#ifndef ZIG_GL
	int w = text_length(MenuFont, entry->dp);
	rect(bmp, entry->x - w - 1, entry->y - 1, entry->x,
		entry->y + text_height(MenuFont), selected ? makecol(255, 255, 0) : 0);

	textout_right(bmp, MenuFont, entry->dp,
		entry->x, entry->y, selected ? COLOUR_WHITE : entry->d);
#else
#endif
}



/* md_selection(): use as follows:

   For example: "Animal Abundance: None / Rare / Moderate / Profuse"

   "Animal Abundance:" is the actual option. Display it with md_text_right(),
   and activate it with mk_option() or your own custom function.
   It will go white when selected, although the word to the right won't
   change colour.

   Display the word to the right using md_selection(). It is a non-option.

   d is the colour.
   dp points to the option in question, which should be a 0-based int.
   dp2 points to an array of char pointers:

   char *array[] = {"None", "Rare", "Moderate", "Profuse"};
   dp2 = array;

   This function will use the int to choose which string to display.
*/
void md_selection(BITMAP *bmp, BOMB_MENU *entry, int selected) {

	(void)selected;

#ifndef ZIG_GL
	textout(bmp, MenuFont, ((char **)entry->dp2) [*(int *)entry->dp],
                                              entry->x, entry->y, entry->d);
#else
#endif
}


void md_bitmap(BITMAP *bmp, BOMB_MENU *entry, int selected) {

#ifndef ZIG_GL
	BITMAP *src = entry->dp;
	blit(src, bmp, 0, 0, entry->x, entry->y, src->w, src->h);
#else
#endif
	(void)selected;
}

void md_mbitmap(BITMAP *bmp, BOMB_MENU *entry, int selected) {
	BITMAP *src = entry->dp;
	(void)selected;
	masked_blit(src, bmp, 0, 0, entry->x, entry->y, src->w, src->h);
}



/* mk_option().
   kp points to the option in question (an int).
   k2 represents the number of values for this option.
   The left and right arrows will change the value, keeping it within the
   range 0 to k2-1.
*/
int mk_option(BOMB_MENU *entry, int k) {

 switch (k >> 8) {

  case KEY_LEFT:
   (*(int *)entry->kp)--;
   if (*(int *)entry->kp < 0) *(int *)entry->kp += entry->k2;
   play_sound(Sample.MenuBeep1, 0, 0, 0, 255, 1000, FALSE);
   break;

  case KEY_RIGHT:
   (*(int *)entry->kp)++;
   if (*(int *)entry->kp >= entry->k2) *(int *)entry->kp = 0;
   play_sound(Sample.MenuBeep1, 0, 0, 0, 255, 1000, FALSE);
   break;

 }

 return 0;
}



/* Command. kp points to a function, return type int, no parameters. When
   Space or Enter are pressed on this option, the function is called and the
   return value is relayed back to the menu system - so if the command
   function returns 1, the menu will exit. Command functions are prefixed
   with mkc_. This convention is kept throughout the program.
*/
int mk_command(BOMB_MENU *entry, int k) {

 switch (k >> 8) {
  case KEY_ENTER:
  case KEY_SPACE:
   play_sound(Sample.MenuBeep2, 0, 0, 0, 255, 1000, FALSE);
   return (*(int (*)(void))entry->kp)();
 }

 return 0;
}



/* Command function for exiting the menu. Simply returns 1. */
int mkc_exit(void) {
 return 1;
}
