#include <aldumb.h>
#include "main.h"
#include "menu.h"
#include "menuproc.h"
#include "log.h"
#include "zcontrol.h"
#include "screen.h"
#include "options.h"
#include "sound2.h"

static char key_buf[CONTROL_NUM_KEYS][32];

static void config_key(CONTROL *control, int k) {

	int ret;
	int i;
	const char *press_key, *key_name, *which_key;

	int white = makecol(255, 255, 255);
	int black = makecol(0, 0, 0);
	int yellow = makecol(255, 255, 0);

	press_key = translate("PressKeyConfig");	
	which_key = control->type == CONTROL_TYPE_KEYBOARD ? translate("WhichKey") : translate("WhichButton");

	play_sound(Sample.MenuBeep2, 0, 0, 0, 255, 1000, FALSE);

	if (k == -1) {	

		for (i = 0; i < CONTROL_NUM_KEYS; i++) {

			BITMAP *dest = get_screen_buffer();
			ret = 0;

			key_name = translate(control_get_key_binding_name(i));
#ifndef ZIG_GL
			rectfill(dest, 30, 220, 610, 260, black);
			rect(dest, 30, 220, 610, 260, yellow);
			textout(dest, MenuFont, which_key, 35, 225, white);
			textout(dest, MenuFont, key_name, 35 + text_length(MenuFont, which_key) + 12, 225, white);
			textout(dest, MenuFont, "?", 35 + text_length(MenuFont, which_key) + text_length(MenuFont, key_name) + 24, 225, white);
#else
#endif

			free_screen_buffer();

			initiate_choose_key(control, i);

			do {
				al_poll_duh(adp);
				choose_update_joystick();
				ret = control_choose_key();
			} while (!ret);

			if (ret == -1)
				break;
		}
	}
	else {	
		BITMAP *dest = get_screen_buffer();
		ret = 0;

		key_name = translate(control_get_key_binding_name(k));

#ifndef ZIG_GL
		rectfill(dest, 30, 220, 610, 260, black);
		rect(dest, 30, 220, 610, 260, yellow);
		textout(dest, MenuFont, which_key, 35, 225, white);
		textout(dest, MenuFont, key_name, 35 + text_length(MenuFont, which_key) + 12, 225, white);
		textout(dest, MenuFont, "?", 35 + text_length(MenuFont, which_key) + text_length(MenuFont, key_name) + 24, 225, white);
#else
#endif

		free_screen_buffer();

		initiate_choose_key(control, k);

		do {
			al_poll_duh(adp);
			choose_update_joystick();
			ret = control_choose_key();
		} while (!ret);
	}

	return;
}

int mk_config_key(BOMB_MENU *entry, int k) {

	int i;

	switch (k >> 8) {
	case KEY_ENTER:
	case KEY_SPACE:
		config_key(entry->kp, entry->k);
		if (entry->k != -1)
			control_get_key_name(entry->kp, entry->k, entry->dp, 32);
		else {
			for (i = 0; i < CONTROL_NUM_KEYS; i++)
				control_get_key_name(entry->kp, i, key_buf[i], 32);
		}
		play_sound(Sample.MenuBeep2, 0, 0, 0, 255, 1000, FALSE);
	}	

	return 0;
}


int mk_save_keys(BOMB_MENU *entry, int k) {

	switch (k >> 8) {
	case KEY_ENTER:
	case KEY_SPACE:
		set_config_file("bomb.ini");
		save_control_config(player_name[entry->k], entry->kp);
		return 1;
	}

	return 0;
}

int mkc_config_controls(int player_id, int type) {

	int i;
	
	const char *menu_title   = translate("ConfigureControls");
	const char *keys[CONTROL_NUM_KEYS] = {
		translate(control_get_key_binding_name(0)), translate(control_get_key_binding_name(1)),
		translate(control_get_key_binding_name(2)), translate(control_get_key_binding_name(3)),
		translate(control_get_key_binding_name(4)), translate(control_get_key_binding_name(5))
	};
	const char *save_config    = translate("SaveConfig");
	const char *no_save_config = translate("NoSaveConfig");
	const char *all_keys       = translate("ConfigureAllKeys");

	int white = makecol(255, 255, 255);
	int blue = makecol(0, 0, 255);
	int red = makecol(255, 0, 0);
	int green = makecol(0, 255, 0);

	CONTROL *control;

	set_config_file("bomb.ini");
	control = load_control_config(player_orig_name[player_id], type);

	{
	BOMB_MENU keyb_menu[] = {
		/* option draw            x    y      d                dp               dp2            key           k  k2              kp */
		{ 0, &md_text_centre,   320,  20, white,     (char*)menu_title, 0,                       0,           0, 0,              0},

		{ 0, &md_text_right,    290, 110,  blue,        (char*)keys[0], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 110, white,            key_buf[0], 0,          &mk_config_key,           0, 0,        control},

		{ 0, &md_text_right,    290, 130,  blue,        (char*)keys[1], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 130, white,            key_buf[1], 0,          &mk_config_key,           1, 0,        control},

		{ 0, &md_text_right,    290, 150,  blue,        (char*)keys[2], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 150, white,            key_buf[2], 0,          &mk_config_key,           2, 0,        control},

		{ 0, &md_text_right,    290, 170,  blue,        (char*)keys[3], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 170, white,            key_buf[3], 0,          &mk_config_key,           3, 0,        control},

		{ 0, &md_text_right,    290, 190,  blue,        (char*)keys[4], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 190, white,            key_buf[4], 0,          &mk_config_key,           4, 0,        control},

		{ 0, &md_text_right,    290, 210,  blue,        (char*)keys[5], 0,                       0,           0, 0,              0},
		{ 1, &md_text,          300, 210, white,            key_buf[5], 0,          &mk_config_key,           5, 0,        control},

		{ 1, &md_text_centre,   320, 240,  blue,       (char*)all_keys, key_buf,    &mk_config_key,          -1, 0,        control},

		{ 1, &md_text_centre,   320, 270, green,    (char*)save_config, 0,           &mk_save_keys,   player_id, 0,        control},
		{ 1, &md_text_centre,   320, 300,   red, (char*)no_save_config, 0,             &mk_command,           0, 0,      &mkc_exit},

		{ 0, NULL,                0,   0,     0,                  NULL, 0,                    NULL,           0, 0,           NULL}
	};


	/* Fill in key names */
	for (i = 0; i < CONTROL_NUM_KEYS; i++)
		control_get_key_name(control, i, key_buf[i], 32);

	run_bomb_menu(keyb_menu, 2);
	}

	return 0;
}
