/*
BITMAP *block_info[N_TEXTURES][N_SURFACES][N_BLOOD_LEVELS][N_DAMAGE_LEVELS];
*/

/*

KEY: FULL   = all bitmaps are initialised
     SINGLE = a single bitmap is used for all
     UNINIT = no bitmaps are available

*/


#if N_DAMAGE_LEVELS != 3
#error change the DAMAGE_RANGE_* defines
#endif

#ifdef ZIG_GL

#define DAMAGE_RANGE_FULL(tex, surf, blood, SURFTEXBLOOD) {   \
 block_info[tex][surf][blood][0] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][1] = dat[SURFTEXBLOOD##D1_BMP].dat; \
 block_info[tex][surf][blood][2] = dat[SURFTEXBLOOD##D2_BMP].dat; \
 gl_block_info[tex][surf][blood][0] = zig_make_texture(block_info[tex][surf][blood][0]); \
 gl_block_info[tex][surf][blood][1] = zig_make_texture(block_info[tex][surf][blood][1]); \
 gl_block_info[tex][surf][blood][2] = zig_make_texture(block_info[tex][surf][blood][2]); \
}

#define DAMAGE_RANGE_SINGLE(tex, surf, blood, SURFTEXBLOOD) { \
 block_info[tex][surf][blood][0] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][1] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][2] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 gl_block_info[tex][surf][blood][0] = zig_make_texture(block_info[tex][surf][blood][0]); \
 gl_block_info[tex][surf][blood][1] = zig_make_texture(block_info[tex][surf][blood][1]); \
 gl_block_info[tex][surf][blood][2] = zig_make_texture(block_info[tex][surf][blood][2]); \
}

#else

#define DAMAGE_RANGE_FULL(tex, surf, blood, SURFTEXBLOOD) {   \
 block_info[tex][surf][blood][0] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][1] = dat[SURFTEXBLOOD##D1_BMP].dat; \
 block_info[tex][surf][blood][2] = dat[SURFTEXBLOOD##D2_BMP].dat; \
}

#define DAMAGE_RANGE_SINGLE(tex, surf, blood, SURFTEXBLOOD) { \
 block_info[tex][surf][blood][0] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][1] = dat[SURFTEXBLOOD##D0_BMP].dat; \
 block_info[tex][surf][blood][2] = dat[SURFTEXBLOOD##D0_BMP].dat; \
}

#endif

#define SET_TO_NULL(v) memset(&v, 0, sizeof(v))

#define DAMAGE_RANGE_UNINIT(tex, surf, blood) { \
 SET_TO_NULL(block_info[tex][surf][blood]);     \
}


#if N_BLOOD_LEVELS != 3
#error change the BLOOD_RANGE_* defines
#endif

/* DAMAGE_TYPE cannot be UNINIT here */
#define BLOOD_RANGE_FULL(tex, surf, SURFTEX, DAMAGE_TYPE) { \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 0, SURFTEX##B0);     \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 1, SURFTEX##B1);     \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 2, SURFTEX##B2);     \
}

#define BLOOD_RANGE_SINGLE(tex, surf, SURFTEX, DAMAGE_TYPE) { \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 0, SURFTEX##B0);       \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 1, SURFTEX##B0);       \
 DAMAGE_RANGE_##DAMAGE_TYPE(tex, surf, 2, SURFTEX##B0);       \
}

#define BLOOD_RANGE_UNINIT(tex, surf) { \
 SET_TO_NULL(block_info[tex][surf]);    \
}


#if N_SURFACES != 2
#error change the SURFACE_RANGE_* defines
#endif

#define SURFACE_RANGE_FULL(tex, TEX, BLOOD_TYPE, DAMAGE_TYPE) { \
 BLOOD_RANGE_##BLOOD_TYPE(tex, 0, TILE##TEX, DAMAGE_TYPE);      \
 BLOOD_RANGE_##BLOOD_TYPE(tex, 1, WALL##TEX, DAMAGE_TYPE);      \
}

/* SURFACE_RANGE_SINGLE would be a bit silly... */

#define SURFACE_RANGE_UNINIT(tex) { \
 SET_TO_NULL(block_info[tex]);      \
}


#if N_TEXTURES != 10
#error change this table to accommodate new number of textures
#endif

SURFACE_RANGE_FULL(0, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(1, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(2, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(3, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(4, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(5, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(6, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(7, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(8, 00, FULL, SINGLE);
SURFACE_RANGE_FULL(9, 00, FULL, SINGLE);
