/* tilemap.h

   This module handles the tile map as a whole.
   See tile.h for individual tiles.
*/

#ifndef INCLUDED_TILEMAP_H
#define INCLUDED_TILEMAP_H

#include "ripples.h"
#include "tile.h"


typedef struct TILEMAP {

 int w, h;

 TILE **tile; /* Access tiles with map->tile[y][x].f
                 where f is the field you want. */

 /* 'border_texture' is one of the TEXTURE_* constants defined in texture.h.
    It specifies the texture of the outer wall.
 */
 int border_texture;

 RIPPLE_INFO *ripple_info;

} TILEMAP;


/* create_tilemap() does not initialise the tiles. It only allocates memory
   for them. All tile maps should be destroyed with destroy_tilemap() when
   you no longer need them.
*/
TILEMAP *create_tilemap(int w, int h);
void destroy_tilemap(TILEMAP *map);


void update_tilemap(TILEMAP *tilemap);


typedef int (*TILE_COLOUR_PROC)(TILEMAP *map, TILE *tile, int x, int y);


extern TILE_COLOUR_PROC tile_colour_proc[2][N_TILE_TYPES];

extern int tile_use_ripples[N_TILE_TYPES];


#endif /* INCLUDED_TILEMAP_H */
