/* s_exps.h

   Explosion source sprite. See sprite.h for details on sprites in general.

   This sprite is invisible, so it has no sprite_draw_proc entry. Set it to
   null.

   Set the sprite_freedata_proc entry to point to free().
*/

#ifndef INCLUDED_S_EXPS_H
#define INCLUDED_S_EXPS_H

#include "tilemap.h"
#include "sprite.h"


typedef struct EXPSOURCE {
 float size;
 int part;
 float damage_size;
} EXPSOURCE;


/* create_explosion(): spawns an explosion source which inherits the position
   and velocity of the sprite causing the explosion. It uses spawn_sprite()
   in sprite.h. 'size' is the size of the explosion.

   ELABORATE
*/
void create_explosion(SPRITE *sprite, float size);


/* update_exps(): this is the explosion source's sprite_update_proc entry
   (see sprite.h). Each frame it should do the following:

   - Add the velocity to the position, and severely damp the velocity.

   - Use sprite_tilemap_collision() in collide.h. For the callback, use
     stc_stop() in sprhelp.h; the explosion source will stop if it hits a
     wall.

   - Create some explosion particles (see s_expp.h). ELABORATE. The number of
     particles created should be proportional to the 'life' field of the
     source.

   - Decrement the 'life' field.
*/
void update_exps(TILEMAP *map, SPRITE *sprite);


#endif /* INCLUDED_S_EXPS_H */
