#ifndef INCLUDED_S_EXPP_H
#define INCLUDED_S_EXPP_H


/* Colours 240 to 255 will represent a colour gradient from dark brown to
   yellow to white. Black is not included.

   However, it is imperative that the explosions be drawn with colours 0 to
   15. This enables the code to use only partial colour maps instead of whole
   ones, cutting down on memory by a factor of 16.

   In the explosion particles, colour 0 is transparency. All bitmaps should
   peak at 15.
*/


/* explosion_colours[brightness][sprite][background] */
extern unsigned char explosion_colours[16][16][256];

void generate_explosion_colours();


void spawn_expp(SPRITE *sprite, float size);


void draw_expp(BITMAP *bmp, SPRITE *sprite, float cth);
void update_expp(TILEMAP *map, SPRITE *sprite);


/* Expp-expp interaction. Repel, and reinforce particles near to each other.
*/
void si_expp_expp(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);


#endif /* INCLUDED_S_EXPP_H */
