/* options.h

   This handles everything that needs loading from and saving into the
   Allegro config file, which is "bomb.ini".
*/

/* player_control_device[]: duh, player control devices. The numbers stored
   here are indices into the ControlDeviceName[] array declared in control.h.
*/
extern int player_control_device[N_PLAYERS];

/* Arrays containing strings: e.g., "None", "Rare", "Moderate", "Profuse".
   These are used by md_selection() in menuproc.h.
*/

/* animal_rate
   0: "None"
   1: "Rare"
   2: "Moderate"
   3: "Profuse"
*/
#define N_ANIMAL_RATES 4
extern char *animal_rate_desc;
extern int animal_rate;
extern char *animal_rate_name[];

/* explosion_size
   0: "Petty"
   1: "Conspicuous"
   2: "Titanic"
*/
#define N_EXPLOSION_SIZES 3
extern char *explosion_size_desc;
extern int explosion_size;
extern char *explosion_size_name[];

/* resolution_id
   0: "320x200 - Blocky but Fluid"
   1: "400x300 - Somewhere in between"
   2: "640x480 - Sharp but Jerky"
*/
#define N_RESOLUTIONS 4
extern char *resolution_desc;
extern int resolution_id;
extern char *resolution_name[];
extern int resolution_w[];
extern int resolution_h[];

/* texturing_id
   0: "Approximate" - POLYTYPE_ATEX
   1: "Precise"     - POLYTYPE_PTEX
*/
#define N_TEXTURING_IDS 2
extern char *texturing_desc;
extern int texturing_id;
extern char *texturing_name[];
extern int texturing_type[]; /* POLYTYPE_* constants */

/* ripple_quality
   0: "Off"
   1: "Blocky"
   2: "Less Blocky"
   3: "Smooth"
*/
#define N_RIPPLE_QUALITIES 4
extern char *ripple_quality_desc;
extern int ripple_quality;
extern char *ripple_quality_name[];


/* load_player_control_devices(): this function loads the contents of
   player_control_device[] from the config file. Use player_name[n], declared
   in main.h, for the section. 'n' goes from 0 to N_PLAYERS - 1. Read two
   ints from the config file, named "device_type" and "device_id". Pass these
   to control_identify_device(), and store the return value in
   player_control_device[n].

   Finally, check whether all players are set to "Off" (device number 0). If
   so, initialise them so that Player 0's device is 'human_device' and the
   others are set to 'zig_ai_device'. These two variables are declared in
   control.h.

   This is called by load_options().
*/
void load_player_control_devices();

/* save_player_control_devices(): this saves the contents of the
   player_control_device[] array. It uses the ControlDeviceName[] array,
   declared in control.h, to get the name of the device.

   This is called by save_options().
*/
void save_player_control_devices();


/* load_options() should be called once at the beginning of the program.
   save_options() should be called once at the end. These functions use the
   Allegro configuration routines, and load_options() sets default values if
   necessary. Each function also calls the respective
   *_player_control_devices() function.
*/
void load_options();
void save_options();

const char* get_language();
