/* THIS MODULE IS UNFINISHED */

/* m_game.h

   The Game Menu:

     <title>Make Your Game        +-------------+
                                  :             :
     [0] Name0  [k] Keyboard 1    : Rotating    :
     [1] Name1  [j] Joystick 1    : preview of  :
     [2] Name2  [c] Zig AI        : currently   :
     [3] Name3      Off           : selected    :
                                  : arena       :
     Arena: Way To Destruction    :             :
                                  : This should :
     Play For Great Justice       : be a square :
                                  :             :
     Main Screen Return On        +-------------+

   [0] - [3] are portraits of the players. Player numbers are not displayed
   anywhere. The names are drawn with md_text() (see menuproc.h), using the
   player_#_name strings in main.h (not player_name[]). [k], [j] and [c] are
   pictures of a keyboard, a joystick and Cats respectively, to be drawn
   using md_control_image().

   A rotating preview of the arena is shown on the right-hand side. Use the
   functions in preview.h to implement this feature.

   See menu.h and menuproc.h for details on how to implement the menu.
   control.h provides int n_control_types and char **control_name for use
   with md_selection() for the controller type. See menuproc.h for details.

   The mkc_*() functions for use with these menu commands are available in
   game.h and menuproc.h (the latter is just an ordinary 'exit menu'
   command).

   If you don't know what that means, read menu.h and menuproc.h already!
*/

#ifndef INCLUDED_M_GAME_H
#define INCLUDED_M_GAME_H

#include "menu.h"
#include "zcontrol.h"


/* md_control_image(): this determines the player's control type using
   player_control_type[d] along with ControlDeviceType[]. The latter is
   declared in control.h. Then, if the type is nonzero, it looks up a
   datafile index in control_image_id[] and draws the datafile object with
   draw_sprite().
*/
void md_control_image(BITMAP *bmp, BOMB_MENU *entry, int selected);


/* SHOULD BE IN GAME.C */
/* create_player_control(): this uses player_control_device[p] as an index to
   ControlDeviceType[] to determine the type of control that player p is
   using. It then acts as follows:

   Off      - Store null in player_control[].

   Keyboard - Use load_control_config(), passing player_name[p] as the
              section name.

   Joystick - Use load_control_config(), passing "joystick#" as the section
              name. Replace the '#' with '1' + ControlDeviceID[p].

   Zig AI   - Use create_control(). There are no options to be loaded.

   player_name[] is declared in main.h. player_control_device[] is declared
   in options.h. The other arrays and the functions are declared in
   control.h.
*/
void create_player_control(int p);


/* mk_control(). This is used on the players' names. k is the player number.

   If the left or right arrows are pressed:
   - Use destroy_control() on player_control[k].
   - Change player_control_device[k] appropriately. It should wrap in the
     range 0 to NumControlDevices - 1.
   - Use create_player_control() on player 'k'.

   NumControlDevices is declared in control.h and is initialised by
   initialise_control(). You do not need to call initialise_control() from
   this module - the main module does that.

   If Enter or Space are pressed, this function checks the type of controller
   (see create_player_control()'s comments for details on how to do this).

   Keyboard - use run_control_menu() in m_ctrl.h, passing 'k' as the player
              number. This menu will save the configuration on exit.

   Joystick - use run_control_menu() in m_ctrl.h, passing 'k' as the player
              number. This menu will save the configuration on exit.

   TODO: ELABORATE ON THESE

   Zig AI   - do nothing. There are no options for this controller.
*/
int mk_control(BITMAP *bmp, BOMB_MENU *entry, int k);

extern BOMB_MENU game_menu[];

/* Command function to run submenu 'game_menu'; used by m_main.h. This
   function should *NOT* initialise and shut down the menu system.

   - Call create_player_control() for each player.
   - Call run_bomb_menu().
   - Call destroy_player_control() for each player.
   - Return 0.
*/
int mkc_game_menu(void);

#endif /* INCLUDED_M_GAME_H */
