/* interact.h

   This module houses all sprite interaction functions that cannot easily be
   assigned to a single sprite's module.
*/

#ifndef INCLUDED_INTERACT_H
#define INCLUDED_INTERACT_H

#include "sprite.h"

/* Generic collision detection between two sprites. Any player sprites
   involved in the collision will lose health depending on the impact speed.

   In addition to collision detection, magnetic bombs attract each other, and
   they attract players.
*/
void si_collision(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);


/* Player-expp interaction. Repel, and hurt player on contact. */
void si_player_expp(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);


/* Bomb-expp interaction. Repel, and explode bomb on contact. */
void si_bomb_expp(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);


/* Generic repulsion between two sprites. */
void si_repel(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);


/* Bomb-player interaction */
void si_bomb_player(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);

/* Explosion source interaction */
void si_exps(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);



#endif /* INCLUDED_INTERACT_H */
