#ifndef INCLUDED_DRAW_H
#define INCLUDED_DRAW_H

/* NOTES FOR LATER:

   This file must be usable by the menu as well as the game.
   See preview.h.

   The polygons should be drawn using texturing_type[texturing_id] from
   options.h, which is a POLYTYPE_* constant.

   Exceptions:

   When ripples are turned off, ripple tiles should be drawn with
   POLYTYPE_FLAT. Walls surrounding ripple tiles are also drawn with
   POLYTYPE_FLAT.

   Sprites, however, should always be
   drawn with POLYTYPE_ATEX_MASK.


   update_joystick() is then responsible for reading the joystick. It need
   not be locked. It must be called as often as possible within reason. To
   that end, it will be called at several points during the draw_game()
   function in game.h. It will also be called once at the beginning of
   update_game() in game.h, to make sure the joysticks are up to date before
   we try to read their FIFOs.
*/

#include "allegro.h"
#include "sprite.h"
#include "tilemap.h"

void draw_level(BITMAP *dest, TILEMAP *map, SPRITE *sprite, MATRIX_f *cam,
                int xc, int yc, float zc, float cth);

void initialise_draw(void);
void shut_down_draw(void);

void clean_up_draw(void);


#endif /* INCLUDED_DRAW_H */
