#ifndef INCLUDED_AI_H
#define INCLUDED_AI_H

#include "sprite.h"
#include "game.h"

/*

NOTES for Dgege:

update_ai() will be called at a rate of 100 Hz for each AI player, same as
the physics rate.

See game.h for info on the game. Use the TILEMAP and SPRITE fields only.
See sprite.h for info on the SPRITE struct.

sprite->player gives you a PLAYER struct. See player.h.

sprite->player->control gives you a CONTROL struct. See control.h.

sprite->player->data may be allocated to whatever you need it for. Make sure
free_ai_data() can safely deallocate it - this will be called if the game is
aborted or concluded. When the player is created, this field will be null.

Use control_press_key() and control_release_key() to control the player.


Please browse around the s_*.h files, etc., and see what sprites can exist.
Always allow for the possibility that more be added without breaking the AI.
Same with powerups - see s_pwrup.h.

Tell us if you need anything else :-)

*/

void update_ai(GAME *game, SPRITE *plspr);

void free_ai_data(void *data);

#endif /* INCLUDED_AI_H */
