/* Bob */
#include <math.h>

#include "allegro.h"

#include "draw.h"
#include "tile.h"
#include "tilemap.h"
#include "texture.h"
#include "overlay.h"
#include "main.h"
#include "timeloop.h"
#include "s_pwrup.h"
#include "game.h"

#define HP_NUM_RECTS 10


static char *pts = NULL;
static char *game_over_txt = NULL;
static char *you_win_txt = NULL;
static char *game_draw_txt = NULL;

static int white = -1, black = -1, red = -1;

void draw_overlay(BITMAP *dest, PLAYER *pl, PLAYER *playerlist) {

	int x, y, w, h;
	int i;

	FONT *f;

	if (white == -1)
		white = makecol(255, 255, 255);
	if (black == -1)
		black = makecol(0, 0, 0);
	if (red == -1)
		red = makecol(255, 0, 0);

	if (dest->w < 320)
		f = SmallFont;
	else if (dest->w < 640)
		f = font;
	else
		f = LargeFont;

	if (!pts)
		pts = (char*)translate("Pts");
	if (!game_over_txt)
		game_over_txt = (char*)translate("GameOver");
	if (!you_win_txt)
		you_win_txt = (char*)translate("YouWin");
	if (!game_draw_txt)
		game_draw_txt = (char*)translate("DrawGame");
	

	h = text_height(f);
	x = h + text_length(f, "HP") + 2;
	y = h * 2 + h / 6;
	w = (dest->w / 3.6) / HP_NUM_RECTS;

	text_mode(-1);

#ifndef ZIG_GL

	/* Draw Name */
	textout(dest, f, player_name[pl->id], h+1, h/2+1, black);
	textout(dest, f, player_name[pl->id], h, h/2, red);

	/* Draw HP bar */
	textout(dest, f, "HP", h+1, h * 2+1, black);
	textout(dest, f, "HP", h, h * 2, red);
	for (i = 0; i < (pl->hp * HP_NUM_RECTS + pl->maxhp - 1) / pl->maxhp; i++) {
		rectfill(dest, x + 1, y + 1, x + w - 1, y + h*1/2 - 1, makecol(0, 255, 0));
		hline(dest, x, y, x + w, makecol(128, 255, 128));
		vline(dest, x, y + 1, y + h*1/2, makecol(128, 255, 128));
		hline(dest, x + 1, y + h*1/2, x + w, makecol(0, 192, 0));
		vline(dest, x + w, y + 1, y + h*1/2 - 1, makecol(0, 192, 0));
		x += w + 3;
	}

	/* Draw power up box */
	masked_stretch_blit(PowerUpBox, dest, 0, 0, PowerUpBox->w, PowerUpBox->h, (int)(dest->w * .45), h / 2, dest->w / 10, dest->h / 10);

	/* Draw power up */
	if (Powerup[pl->held_powerup][0]) {
		if ((game_time - pl->powerup_time) >= 150 || ((game_time - pl->powerup_time) % 50) < 25)
			masked_stretch_blit(Powerup[pl->held_powerup][0], dest, 0, 0,
				Powerup[pl->held_powerup][0]->w, Powerup[pl->held_powerup][0]->h,
				(int)(dest->w * .45), h / 2, dest->w / 10, dest->h / 10);
	}


	/* Draw bombs left */
	masked_stretch_blit(MiniBomb, dest, 0, 0, MiniBomb->w, MiniBomb->h, INT(dest->w * 0.57), h * 10/8,
		MiniBomb->w * dest->w / 640, MiniBomb->h * dest->w / 640);
	textprintf(dest, f,  INT(dest->w * 0.60), h * 3 / 2, white, "x%02i   x%02i", pl->num_bombs, pl->num_missiles);

	/* Draw other player's names */

	while (playerlist) {

		SPRITE *spr = playerlist->sprite;

		if (spr && playerlist != pl && spr->zview > 1) {
			line(dest, (int)floor(spr->xview) + 10 * dest->w / 640, (int)floor(spr->yview) - 10 * dest->h / 480,
				(int)floor(spr->xview) + 20 * dest->w / 640, (int)floor(spr->yview) - 20 * dest->h / 480, white);
 
			hline(dest, (int)floor(spr->xview) + 20 * dest->w / 640, (int)floor(spr->yview) - 20 * dest->h / 480,
				(int)floor(spr->xview) + text_length(f, player_name[playerlist->id]), white);

			textout(dest, f, player_name[playerlist->id], 
				(int)floor(spr->xview) + 20 * dest->w / 640+1, (int)floor(spr->yview) - 20 * dest->h / 480+1 - text_height(f),
				black);
			textout(dest, f, player_name[playerlist->id], 
				(int)floor(spr->xview) + 20 * dest->w / 640, (int)floor(spr->yview) - 20 * dest->h / 480 - text_height(f), 
				white);
		}

		playerlist = playerlist->next;
	}

	if (pl->held_powerup && pl->powerup_time) {
		if (game_time - pl->powerup_time < 20) {
			int tw = text_length(f, powerup_names[pl->held_powerup]);
			textout(dest, f, powerup_names[pl->held_powerup], -tw + tw * (game_time - pl->powerup_time) / 20, dest->h - text_height(f), white);
		}
		else if (game_time - pl->powerup_time < 120) {
			textout(dest, f, powerup_names[pl->held_powerup], 0, dest->h - text_height(f), white);
		}
		else if (game_time - pl->powerup_time < 140) {
			textout(dest, f, powerup_names[pl->held_powerup], 0, dest->h - text_height(f) + text_height(f) * (game_time - pl->powerup_time - 120) / 20, white);
		}
	}


	/* Draw starting lights */
	if (game_time < 100)
		masked_stretch_blit(StartLight[0], dest, 0, 0, StartLight[0]->w, StartLight[0]->h, dest->w / 2 - dest->w / 10, dest->h / 10 * (game_time - 50) / 50 + h, dest->w / 5, dest->h / 10);
	else if (game_time < 500)
		masked_stretch_blit(StartLight[(game_time - 100) / 100], dest, 0, 0, StartLight[0]->w, StartLight[0]->h, dest->w / 2 - dest->w / 10, dest->h / 10 + h, dest->w / 5, dest->h / 10);
	else if (game_time < 600)
		masked_stretch_blit(StartLight[3], dest, 0, 0, StartLight[3]->w, StartLight[3]->h, dest->w / 2 - dest->w / 10, dest->h / 10 * (550 - game_time) / 50 + h, dest->w / 5, dest->h / 10);

	/* Game start - progressively undarken */
	if ((game_time - game_start_time) < 50) {
		int num = dest->h / 2 - MIN(dest->h / 2, (game_time - game_start_time) * dest->h / 50);
		for (i = 0; i < num; i++)
			hline(dest, 0, i * 2 + 1, dest->w-1, 0);
	}
	if ((game_time - game_start_time) < 70) {
		int num = dest->h / 2 - MIN(dest->h / 2, (game_time - game_start_time - 20) * dest->h / 50);
		for (i = 0; i < num; i++)
			hline(dest, 0, i * 2, dest->w-1, 0);
	}


	/* Darken the screen for dead players */
	if (pl->hp <= 0 && pl->time_of_death && (game_time - pl->time_of_death) > 100) {
		int num = MIN(dest->h / 2, (game_time - pl->time_of_death - 100) * dest->h / 200);
		for (i = 0; i < num; i++)
			hline(dest, 0, i * 2, dest->w-1, 0);

		textout_centre(dest, LargeFont, game_is_draw ? game_draw_txt : game_over_txt, dest->w/2, dest->h/2 - text_height(LargeFont)/2, white);
	}

	if (!game_is_draw && pl->won)
		textout_centre(dest, LargeFont, you_win_txt, dest->w/2, dest->h/2 - text_height(LargeFont)/2, white);

	if (player_won && !pl->won && (game_time - player_won->won) > 200) {
		int num = MIN(dest->h / 2, (game_time - player_won->won - 200) * dest->h / 200);
		for (i = 0; i < num; i++)
			hline(dest, 0, i * 2 + 1, dest->w-1, 0);
	}
	else if (game_is_draw || (player_won && (game_time - player_won->won) > 600)) {
		int num = (game_is_draw ? (MIN(dest->w/2, (game_time - game_draw_time - 400) * dest->w / 200))
				: (MIN(dest->w/2, (game_time - player_won->won - 600) * dest->w / 200)));
		for (i = 0; i < dest->h; i++)
			hline(dest, 0, i, num, 0);
		for (i = 0; i < dest->h; i++)
			hline(dest, dest->w - num, i, dest->w, 0);
	}

	//textprintf(dest, font, 0, 0, white, "%i fps", fps);
#else
#endif

	return;
}
