/* entheh */

#include "main.h"
#include "screen.h"
#include "timeloop.h"
#include "menu.h"
#include "sound2.h"


typedef struct BM_DATA {
 BOMB_MENU *menu;
 int sel;
 int size;
} BM_DATA;



void initialise_menu_system(void) {
}



void shut_down_menu_system(void) {
}



#define menu (((BM_DATA *)data)->menu)
#define sel  (((BM_DATA *)data)->sel)
#define size (((BM_DATA *)data)->size)

static int bm_update(void *data) {

 int k;

 while (keypressed()) {
  k = readkey();

  switch (k >> 8) {

   case KEY_ESC:
	play_sound(Sample.MenuBeep2, 0, 0, 0, 255, 1000, FALSE);
    return 1;

   case KEY_UP:
    do {
     sel--;
     if (sel < 0) sel += size;
    } while (menu[sel].option == 0);
	play_sound(Sample.MenuBeep1, 0, 0, 0, 255, 1000, FALSE);
    break;

   case KEY_DOWN:
    do {
     sel++;
     if (menu[sel].draw == 0) sel = 0;
    } while (menu[sel].option == 0);
	play_sound(Sample.MenuBeep1, 0, 0, 0, 255, 1000, FALSE);
    break;

   default:
    return (*menu[sel].key)(&menu[sel], k);

  }
 }

 return 0;
}



static void bm_draw(void *data) {

 int m;
 BITMAP *bmp = get_screen_buffer();

 clear(bmp);

 for (m = 0; menu[m].draw; m++)
  (*menu[m].draw)(bmp, &menu[m], m == sel);

 free_screen_buffer();
}

#undef size
#undef sel
#undef menu



void run_bomb_menu(BOMB_MENU *menu, int selection) {

 BM_DATA data = {menu, selection, 0};

 for (; menu[data.size].draw; data.size++) { }

 timeloop(BPS_TO_TIMER(100), 30, &data, &bm_update, &bm_draw);
}
