#include "main.h"
#include "menu.h"
#include "menuproc.h"
#include "game.h"
#include "m_main.h"
#include "m_option.h"
#include "m_game.h"
#include "options.h"
#include "screen.h"


static int language_number = 0;

int mk_lang(BOMB_MENU *entry, int k) {

	int last_lang = *((int*)entry->kp);
	int ret = mk_option(entry, k);

	if (last_lang != *((int*)entry->kp)) {
		set_config_file("bomb.ini");
		set_config_int("game", "language", *((int*)entry->kp));
        install_multilang(get_language());
	}

	return ret;
}



int mkc_option_menu() {

	char *animal_rate_desc2 = (char*)translate(animal_rate_desc);
	char *animal_rate_name2[] = {
		(char*)translate(animal_rate_name[0]), (char*)translate(animal_rate_name[1]),
		(char*)translate(animal_rate_name[2]), (char*)translate(animal_rate_name[3])
	};

	char *explosion_size_desc2 = (char*)translate(explosion_size_desc);
	char *explosion_size_name2[] = {
		(char*)translate(explosion_size_name[0]), (char*)translate(explosion_size_name[1]),
		(char*)translate(explosion_size_name[2])
	};

	char *resolution_desc2 = (char*)translate(resolution_desc);
	char *resolution_name2[] = {
		(char*)translate(resolution_name[0]), (char*)translate(resolution_name[1]), 
		(char*)translate(resolution_name[2]), (char*)translate(resolution_name[3])
	};

	char *texturing_desc2 = (char*)translate(texturing_desc);
	char *texturing_name2[] = {
		(char*)translate(texturing_name[0]), (char*)translate(texturing_name[1])
	};

	char *ripple_quality_desc2 = (char*)translate(ripple_quality_desc);
	char *ripple_quality_name2[] = {
		(char*)translate(ripple_quality_name[0]), (char*)translate(ripple_quality_name[1]),
		(char*)translate(ripple_quality_name[2]), (char*)translate(ripple_quality_name[3])
	};

	char *txt_return = (char*)translate(txt_return_to_main);

	char *language_name[] = {"English", "Francais", "Castellano"};
	BITMAP *language_flag[] = {dat[UK_FLAG_BMP].dat, dat[FRANCE_FLAG_BMP].dat, dat[SPAIN_FLAG_BMP].dat};

	int white = makecol(255, 255, 255);
	int blue =  makecol(0, 0, 255);

	int old_lang;

	set_config_file("bomb.ini");
	language_number = get_config_int("game", "language", 0);
	old_lang = language_number;


	{
	BOMB_MENU option_menu[] = {
		/* option draw         x    y   d                dp               dp2                   key          k  k2              kp */
		{ 1, &md_text_right , 290, 210, blue ,        animal_rate_desc2,   0,                   &mk_option,  0, N_ANIMAL_RATES, &animal_rate},
		{ 0, &md_selection  , 300, 210, white,        &animal_rate,        animal_rate_name2,   0,           0, 0             , 0           },

		{ 1, &md_text_right , 290, 230, blue ,        explosion_size_desc2,0,                   &mk_option,  0, N_EXPLOSION_SIZES, &explosion_size},
		{ 0, &md_selection  , 300, 230, white,        &explosion_size,     explosion_size_name2,0,           0, 0                , 0           },

		{ 1, &md_text_right , 290, 250, blue ,        resolution_desc2,    0,                   &mk_option,  0, N_RESOLUTIONS, &resolution_id},
		{ 0, &md_selection  , 300, 250, white,        &resolution_id,      resolution_name2,    0,           0, 0                , 0           },

		{ 1, &md_text_right , 290, 270, blue ,        texturing_desc2,     0,                   &mk_option,  0, N_TEXTURING_IDS, &texturing_id},
		{ 0, &md_selection  , 300, 270, white,        &texturing_id,       texturing_name2,     0,           0, 0                , 0           },

		{ 1, &md_text_right , 290, 290, blue ,        ripple_quality_desc2,0,                   &mk_option, 0,  N_RIPPLE_QUALITIES, &ripple_quality},
		{ 0, &md_selection  , 300, 290, white,        &ripple_quality,     ripple_quality_name2,0,          0,  0                   , 0           },

		{ 1, &md_control_image,256,  320, 0,     &language_number,        language_flag,        &mk_lang,    0, N_LANGUAGES   , &language_number },
		{ 0, &md_selection,    256,  390, white, &language_number,        language_name,        0,           0, 0             , 0           },


        { 1, &md_text_centre, 320, 420, blue ,        txt_return        ,  0               , &mk_command, 0, 0             , &mkc_exit   },
		{ 0, 0              ,   0,   0,            0, 0                 ,  0               , 0          , 0, 0             , 0           }
	};
	run_bomb_menu(option_menu, 0);
	}

	set_config_file("bomb.ini");
	language_number = get_config_int("game", "language", 0);	

	save_options();
	
	if (old_lang != language_number)
		control_identify_devices();

	return 0;
}
