/* Entheh */
/* m_main.h

   The Main Menu:

     <"Set Up Us The Bomb" logo> - ??? (not allowed for; may be removed)

     Make Your Game
     Set Up Us The Options
     You Have No Chance To Exit

   See menu.h and menuproc.h for details on how to implement the menu.

   These commands should be centred in the middle of the screen. Use
   md_text_centre() from menuproc.h.

   The mkc_*() functions for use with these menu commands are available in
   m_game.h, m_option.h and menuproc.h respectively (the last one is just an
   ordinary 'exit menu' command).

   If you don't know what that means, read menu.h and menuproc.h already!
*/

#include "main.h"
#include "menu.h"
#include "menuproc.h"
#include "game.h"
#include "m_main.h"
#include "m_option.h"
#include "m_game.h"
#include "log.h"

/* For use by other menus */
unsigned char *txt_return_to_main = "MainScreenReturnOn";

/* The main menu is the first and last menu the user will ever see. Hence, in
   addition to running the menu itself, run_main_menu() is responsible for
   calling initialise_menu_system() and shut_down_menu_system().
*/
void run_main_menu() {

	const char *txt_play_game =   translate("MakeYourGame");
	const char *txt_set_options = translate("SetUpUsTheOptions");
	const char *txt_exit_game =   translate("YouHaveNoChanceToExit");

	const char *marquee_txt1 = translate("MarqueeText1");
	const char *marquee_txt2 = translate("MarqueeText2");
	const char *marquee_txt3 = translate("MarqueeText3");
	const char *marquee_txt4 = translate("MarqueeText4");
	const char *marquee_txt5 = translate("MarqueeText5");
	const char *marquee_txt6 = translate("MarqueeText6");

	int marqueex1 = 0;
	int marqueex2 = text_length(MenuFont, marquee_txt1) + 600 + marqueex1;
	int marqueex3 = text_length(MenuFont, marquee_txt2) + 600 + marqueex2;
	int marqueex4 = text_length(MenuFont, marquee_txt3) + 600 + marqueex3;
	int marqueex5 = text_length(MenuFont, marquee_txt4) + 200 + marqueex4;
	int marqueex6 = text_length(MenuFont, marquee_txt5) + 200 + marqueex5;

	int blue = makecol(0, 0, 255);
	int white = makecol(255, 255, 255);

	{
 BOMB_MENU main_menu[] = {
  /* option draw         x    y   d                dp                  dp2  key         k  k2 kp */
  { 1, &md_text_centre, 320, 310, blue,         (char*)txt_play_game  , 0, &mk_command, 0, 0, &mkc_game_menu  },
  { 1, &md_text_centre, 320, 330, blue,         (char*)txt_set_options, 0, &mk_command, 0, 0, &mkc_option_menu},
  { 1, &md_text_centre, 320, 350, blue,         (char*)txt_exit_game  , 0, &mk_command, 0, 0, &mkc_exit       },
  { 0, &md_bitmap,      230,  60, 0,            Logo2,                  0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex1,460, white,        (char*)marquee_txt1,    0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex2,460, white,        (char*)marquee_txt2,    0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex3,460, white,        (char*)marquee_txt3,    0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex4,460, white,        (char*)marquee_txt4,    0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex5,460, white,        (char*)marquee_txt5,    0, 0,           0, 0, 0               },
  { 0, &md_marquee,marqueex6,460, white,        (char*)marquee_txt6,    0, 0,           0, 0, 0               },
  { 0, 0              ,   0,   0,            0, 0                     , 0, 0          , 0, 0, 0               }
 };

 text_mode(-1);
 initialise_menu_system();
 run_bomb_menu(main_menu, 0);
 shut_down_menu_system();
	}
}
