#include <string.h>
#include "main.h"
#include "texture.h"
#include "level.h"
#include "levelmze.h"
#include "s_anim_s.h"

void load_maze_level(const char *filename, int attrib, int param) {

 PACKFILE *f;
 char str[9];
 LEVEL *level;
 char *level_name;

 (void)attrib;
 (void)param;

 if (n_levels >= MAX_LEVELS) {
  errno = ENOMEM;
  return;
 }

 f = pack_fopen(filename, F_READ);

 if (f == 0) goto whoops_opening;

 if (pack_fread(str, 9, f) < 9) goto whoops_confirming;
 if (memcmp(str, "MazeLevel", 9)) goto whoops_confirming;

 level = malloc(sizeof(LEVEL));
 if (!level) goto whoops_confirming;
 memset(level, 0, sizeof(LEVEL));

 {
  int n = pack_getc(f);
  if (errno || n == 0) goto whoops_naming;

  level_name = malloc(n + 1);
  if (!level_name) goto whoops_naming;
  pack_fread(level_name, n, f);
  level_name[n] = 0;
 }

 {
  int w, h;
  w = pack_getc(f);
  h = pack_getc(f);
  if (errno || w == 0 || h == 0) goto whoops;
  level->map = create_tilemap(w, h);
  if (!level->map) exit(37);
 }

 /* STTIME (time allocated to players at start); skip */
 pack_igetw(f);

 /* Maze had 8 players; read in first N_PLAYERS and skip the rest */
 {
  int p;
  for (p = 0; p < N_PLAYERS; p++) {
   level->player[p].x = pack_getc(f);
   level->player[p].y = pack_getc(f);
   level->player[p].dir = 0;
  }
  for (p = 0; p < ((8 - N_PLAYERS) << 1); p++) pack_getc(f);
 }

 /* XEND,YEND ending square; skip */
 pack_getc(f);
 pack_getc(f);

 {
  int x, y;

  for (y = 0; y < level->map->h; y++) {
   for (x = 0; x < level->map->w; x++) {
    level->map->tile[y][x].z = pack_igetw(f) * (1.0 / 8.0);
   }
  }

  for (y = 0; y < level->map->h; y++) {
   for (x = 0; x < level->map->w; x++) {
    /* 0 - grass
       1 - bricks
       2,3,4,5,6 - water (different flow directions)
    */
    TILE *tile = &level->map->tile[y][x];
    switch (pack_getc(f)) {
     case 0:
      tile->texture = 10;
      break;
     case 1:
      tile->texture = 0;
      break;
     default:
      tile->texture = TEXTURE_WATER;
    }
    tile->type = (((tile->texture == TEXTURE_WATER) || (tile->texture == TEXTURE_ACID)) ? TILE_TYPE_LIQUID
               : ((tile->texture == TEXTURE_LAVA) ? TILE_TYPE_LAVA
               : TILE_TYPE_SOLID));

   }
  }

  /* Skip LWALL textures */
  for (y = 0; y < level->map->h; y++) {
   for (x = 0; x <= level->map->w; x++) {
    pack_getc(f);
   }
  }

  /* Skip TWALL textures */
  for (y = 0; y <= level->map->h; y++) {
   for (x = 0; x < level->map->w; x++) {
    pack_getc(f);
   }
  }
 }

 /* Skip all items, constituting remainder of file */

/* QuickBASIC code:

 GETBYTES FILEATTR(F, 2), 1&, VARSEG(ITEMS), VARPTR(ITEMS)
 FOR I = 0 TO ITEMS - 1
  GETBYTES FILEATTR(F, 2), 1&, VARSEG(ITEM(I).I), VARPTR(ITEM(I).I)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).X), VARPTR(ITEM(I).X)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).Y), VARPTR(ITEM(I).Y)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).Z), VARPTR(ITEM(I).Z)
 NEXT
*/

 if (errno) goto whoops;

 pack_fclose(f);

 /* Create an animal portal in each corner */
 level->portalsprite = add_portal_sprite(level->map, level->portalsprite, 0, 0);
 level->portalsprite = add_portal_sprite(level->map, level->portalsprite, level->map->w-1, 0);
 level->portalsprite = add_portal_sprite(level->map, level->portalsprite, level->map->w-1, level->map->h-1);
 level->portalsprite = add_portal_sprite(level->map, level->portalsprite, 0, level->map->h-1);

 the_levels[n_levels] = level;
 the_level_names[n_levels] = level_name;
 n_levels++;
 return;

whoops:
 free(level_name);
whoops_naming:
 destroy_level(level);
whoops_confirming:
 pack_fclose(f);
whoops_opening:
 errno = 0;
}

/* Complete QuickBASIC code:

SUB LOADLEVEL (F$)
F = FREEFILE
OPEN "I", #F, "LEVELS\" + F$
T$ = STRING$(9, 0)
GETBYTES FILEATTR(F, 2), 9&, SSEG(T$), SADD(T$)
IF T$ = "MazeLevel" THEN
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(N), VARPTR(N)
 LEVELNAME = ""
 GETBYTES FILEATTR(F, 2), N, VARSEG(LEVELNAME), VARPTR(LEVELNAME)
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(XSIZE), VARPTR(XSIZE)
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(YSIZE), VARPTR(YSIZE)
 GETBYTES FILEATTR(F, 2), 2&, VARSEG(STTIME), VARPTR(STTIME)
 FOR P = 0 TO PLAYERS - 1
  GETBYTES FILEATTR(F, 2), 1&, VARSEG(PLAYER(P).XST), VARPTR(PLAYER(P).XST)
  GETBYTES FILEATTR(F, 2), 1&, VARSEG(PLAYER(P).YST), VARPTR(PLAYER(P).YST)
 NEXT
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(XEND), VARPTR(XEND)
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(YEND), VARPTR(YEND)
 FOR Y = 0 TO YSIZE - 1
  FOR X = 0 TO XSIZE - 1
	GETBYTES FILEATTR(F, 2), 2&, VARSEG(LAND(X, Y).H), VARPTR(LAND(X, Y).H)
  NEXT
 NEXT
 FOR Y = 0 TO YSIZE - 1
  FOR X = 0 TO XSIZE - 1
	GETBYTES FILEATTR(F, 2), 1&, VARSEG(LAND(X, Y).F), VARPTR(LAND(X, Y).F)
  NEXT
 NEXT
 FOR Y = 0 TO YSIZE - 1
  FOR X = 0 TO XSIZE
	GETBYTES FILEATTR(F, 2), 1&, VARSEG(LWALL(X, Y)), VARPTR(LWALL(X, Y))
  NEXT
 NEXT
 FOR Y = 0 TO YSIZE
  FOR X = 0 TO XSIZE - 1
	GETBYTES FILEATTR(F, 2), 1&, VARSEG(TWALL(X, Y)), VARPTR(TWALL(X, Y))
  NEXT
 NEXT
 GETBYTES FILEATTR(F, 2), 1&, VARSEG(ITEMS), VARPTR(ITEMS)
 FOR I = 0 TO ITEMS - 1
  GETBYTES FILEATTR(F, 2), 1&, VARSEG(ITEM(I).I), VARPTR(ITEM(I).I)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).X), VARPTR(ITEM(I).X)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).Y), VARPTR(ITEM(I).Y)
  GETBYTES FILEATTR(F, 2), 2&, VARSEG(ITEM(I).Z), VARPTR(ITEM(I).Z)
 NEXT
ELSE
 'Not a proper level; "MazeLevel" missing
END IF
CLOSE #F
END SUB
*/

void add_maze_levels() {
 for_each_file("data/*.mze", FA_RDONLY | FA_HIDDEN | FA_SYSTEM | FA_LABEL | FA_DIREC | FA_ARCH, &load_maze_level, 0);
}
