/* Bob */

#include <math.h>
#include "main.h"
#include "screen.h"
#include "timeloop.h"
#include "sprite.h"
#include "s_bomb.h"
#include "s_player.h"
#include "draw.h"
#include "options.h"


/* Game's intro screen */
int update_intro(void *data) {
	SPRITE *list = data;

	int k = 0;

	update_sprites(NULL, &list); /* Players are handled here. */


	if (keypressed()) {
		k = readkey();
		return 1;
	}

	if (game_time > 900)
		return 1;

	return 0;
}


void draw_intro(void *data) {
	SPRITE *list = data;

	BITMAP *buf = get_screen_buffer();

	MATRIX_f camera = identity_matrix_f;
	qtranslate_matrix_f(&camera, -.5, -.5, 4.5);

#ifndef ZIG_GL
	clear(buf);
	draw_level(buf, NULL, list, &camera, 0, .5, .5, 0);

	if (game_time > 500 && game_time < 550) {
		rotate_scaled_sprite(buf, Logo2, 320 - (game_time - 500) * 6, 240 - INT((game_time - 500) * 5.6), -itofix(game_time - 500) / 2, itofix(game_time - 490) / 20);
	}
	else if (game_time >= 550 && game_time < 600)
		rotate_scaled_sprite(buf, Logo2, 20, -40, -itofix(25), ftofix(60.0 + cos((game_time - 550) / 2.5) * 2.0) / 20);
	else if (game_time >= 600 && game_time < 700)
		rotate_scaled_sprite(buf, Logo2, 20, -40, -itofix(25), ftofix(3.0));
	else if (game_time >= 700 && game_time <= 900)
		rotate_scaled_sprite(buf, Logo2, 20 + INT((game_time - 700) * 1.05), -40 + INT((game_time - 700) / 2.0), -itofix(25) + ftofix((game_time - 700) / 8), ftofix(3.0 - (game_time - 700) / 100.0));
#else
#endif

	free_screen_buffer();
}


void run_intro() {

	SPRITE *list = NULL;
	int old_exp_size = explosion_size;
	explosion_size = 0;

	/* Place a bomb */
	list = add_player_sprite(NULL, list, NULL, 0, 0, 0);
	spawn_bomb(list, -1);
	// list = destroy_sprite(list);

	timeloop(BPS_TO_TIMER(100), 30, list, &update_intro, &draw_intro);

	explosion_size = old_exp_size;
}
