#ifndef INCLUDED_TEXTURE_H
#define INCLUDED_TEXTURE_H

#include "tilemap.h"


/*
tile.h - This handles individual tiles. It must manage textures and ripples,
  solid and liquid behaviour, subsidence and collapse * of tiles versus safe
  tiles, tiles that crack or singe, moving tiles (lifts), and any other nice
  ideas that would not require much effort to implement.
*/


/* Used to define which tile can be subsided */
#define TEXTURE_NUM_SUBSIDABLE 252

/* For use when loading levels only. */
#define TEXTURE_PORTAL 252
#define TEXTURE_WATER 253
#define TEXTURE_ACID  254
#define TEXTURE_LAVA  255


int tile_s_colour(TILEMAP *map, TILE *tile, int x, int y);
int tile_w_colour(TILEMAP *map, TILE *tile, int x, int y);


#endif /* INCLUDED_TEXTURE_H */
