/* sprhelp.h

   Helper functions for the sprites. If there is any nontrivial operation
   that may be useful for more than one sprite, but cannot be applied blindly
   to all sprites, you will find a function for the purpose here. For
   example, both bombs and players will find draw_generic_sprite() useful -
   but they each have to specify different bitmaps according to different
   data, and explosion particles cannot use it.
*/


#ifndef INCLUDED_SPRHELP_H
#define INCLUDED_SPRHELP_H

#include "sprite.h"



void extrapolate_sprite_no_th(SPRITE *sprite);



/* Adds the sprite velocity to the position, ensuring that the sprite is not
   moving too fast, and checking that the angle is within the primary range
   (0 - 2*M_PI).
*/
void extrapolate_sprite(SPRITE *sprite);



/* sprite_direction(): pass the sprite's 'th' (theta) field, and the camera
   angle (the value of 'cth' passed to the sprite draw proc - see sprite.h).
   This function will return an integer direction, from 0 to 7, indicating
   which of eight bitmaps should be used to draw the sprite.

   0 - facing away from the camera
   2 - facing to the right
   4 - facing towards the camera
   6 - facing to the left

   1,3,5,7 are the diagonals in between (7 is between 6 and 0).

   The datafile is constructed in such a way that you can just add this value
   on to the index of the first bitmap.
*/
int sprite_direction(float sth, float cth);


/* draw_generic_sprite(): 'bmp' is the bitmap on to which the sprite should
   be drawn. 'sprite' is the SPRITE struct (see sprite.h); it will be used
   for its 'xview', 'yview', 'xrad' and 'yrad' fields. 'spritebmp' is the
   image you want to use, and must have dimensions equal to powers of 2 (32,
   64, 128, etc.).

   This function won an award for most confusing parameter list, second only
   to the ENVELOPE statement on the BBC Microcomputer.
*/
void draw_generic_sprite(BITMAP *bmp, SPRITE *sprite, BITMAP *spritebmp,
                                                      int polytype);


/* stc_stop(): callback function for use with sprite_tilemap_collision() in
   collide.h. This causes the sprite to stop dead on collision.
*/
void stc_stop(TILEMAP *map,
              SPRITE *sprite,
              float xi, float yi, float zi,
              float iv,
              int xt, int yt,
              TILE *tile, TILE_SURFACES *hit);


#endif /* INCLUDED_SPRHELP_H */
