/* sound.h

   This module should be used for all sound in the game. It allows

   1. Samples' volume and panning are set up, accommodating all camera
      positions.

   2. Sounds are timed.

   To play a sample,

   This module calculates the volume and panning for a sample depending on
   its source in the level, taking into account the camera positions in all
   viewports on the screen.
*/

#ifndef INCLUDED_SOUND_H
#define INCLUDED_SOUND_H





/* Use this instead for each sound effect that emanates from some point in
   the level. Pass the volume and pan calculated to play_sample(). It may be
   sensible, especially with collisions, not to play very quiet samples.

   THESE COMMENTS AND THIS PARAMETER LIST ARE INCOMPLETE.
*/
void originate_sample(float x, float y, float z, float loud);


void poll_sound();


#endif /* INCLUDED_SOUND_H */
