/* screen.h

   This file acts as a wrapper for setting the graphics mode and running a
   buffering system. Please use the functions in this file instead of using
   set_gfx_mode() and the screen bitmap directly.

   create_screen() sets the graphics mode, returning 0 on success. It also
   initialises the buffering system. If it fails it will return -1. The
   caller should be prepared to deal with this case.

   If create_screen() is called a second time, it will shut down the current
   buffering system before attempting to change the graphics mode. If it
   succeeds it will initialise a new buffering system for the new graphics
   mode. If it fails it will restore the old graphics mode, reinitialise the
   buffering system, and return -1. If it fails in these steps too, it will
   exit with a critical error (allegro_exit() followed by allegro_message()
   followed by exit(1)). The message displayed is as follows:

   "Unable to set graphics mode (<width>x<height>);\n"
   "Unable to restore old graphics mode (<width>x<height>)!\n"
   "<contents of allegro_error>\n"
   "Please take your computer to the vet."

   MAYBE CHANGE THAT...

   destroy_screen() shuts down the buffering system and leaves the graphics
   mode by setting GFX_TEXT. This must be called at the end of the program,
   but nowhere else. To change to a different graphics mode, just call
   create_screen() by itself.

   Do not use atexit() with destroy_screen(), since it must be called before
   allegro_exit()!

   Before rendering a frame of animation for either the game or a menu, call
   get_screen_buffer(). It will return a bitmap pointer, and you should draw
   the frame on to this bitmap, using bitmap->w and bitmap->h to detect its
   size. Do not draw directly on to the screen.

   When you have finished rendering the frame, call free_screen_buffer().
   This will tell the buffering system that the frame is ready to be shown on
   the screen.

   For now, a double buffering system will be implemented. create_screen()
   creates a bitmap the same size as the graphics mode it sets, destroying
   the old one if present. destroy_screen() destroys this bitmap.
   get_screen_buffer() returns the pointer to this bitmap, and
   free_screen_buffer() blits it to the screen.
*/

#ifndef INCLUDED_SCREEN_H
#define INCLUDED_SCREEN_H

int create_screen(int w, int h);
void destroy_screen();

BITMAP *get_screen_buffer();
void free_screen_buffer();

void SwitchCallback(void);

#endif /* INCLUDED_SCREEN_H */
