/* s_player.h

   Player sprite. See sprite.h for details on sprites in general.

   This sprite has no sprite_freedata_proc entry. Set it to null.
*/

#ifndef INCLUDED_S_PLAYER_H
#define INCLUDED_S_PLAYER_H

#include "tilemap.h"
#include "sprite.h"
#include "player.h"



void camera_set_target(TILEMAP *map, CAMERA *camera, SPRITE *sprite);



SPRITE *add_player_sprite(TILEMAP *map, SPRITE *sprite, PLAYER *player,
                                                      int x, int y, int dir);


/* draw_player(): this is the player's sprite_draw_proc entry (see sprite.h).
   Use sprite_direction() to get the direction the player is facing. Then use
   draw_generic_sprite() to draw the sprite. These two functions are in
   sprhelp.h.

   In order to choose a bitmap, use the following formula:

   PLAYER00 + p*(PLAYER10-PLAYER00) + d

   where p is the player number (0 to 3) and d is the direction as returned
   by sprite_direcetion(). This gives a datafile index. Use it to look up the
   appropriate bitmap.
*/
void draw_player_sprite(BITMAP *bmp, SPRITE *sprite, float cth);


/* update_player(): this is the player's sprite_update_proc entry (see
   sprite.h).

   ELABORATE WHEN THE EXTERNAL DATA ARE READY (player.h).
*/
void update_player_sprite(TILEMAP *map, SPRITE *sprite);


#endif /* INCLUDED_S_PLAYER_H */
