/* s_animal.h

   Manages animal behaviour
*/

#ifndef INCLUDED_S_ANIMAL_H
#define INCLUDED_S_ANIMAL_H

#include "s_pwrup.h"
#include "sprite.h"


typedef struct ANIMAL {

 SPRITE *portal; /* Who dropped this bomb? */

 int powerup;

 float col_speed;

 int type;
} ANIMAL;


void spawn_animal(SPRITE *sprite);

void draw_animal(BITMAP *bmp, SPRITE *sprite, float cth);
void update_animal(TILEMAP *map, SPRITE *sprite);
void free_animal_data(void *data);

/* Animal - non-Animal interaction */
void si_animal(TILEMAP *map, SPRITE *spr1, SPRITE *spr2);

#define N_ANIMALS 4


#endif /* INCLUDED_S_ANIMAL_H */
