/* main.h

   All modules must include this file, after any standard headers (e.g.
   math.h, stdio.h, allegro.h) but before any project headers (e.g. menu.h,
   texture.h).
*/



#ifndef INCLUDED_MAIN_H
#define INCLUDED_MAIN_H

#define VERSION "0.8"


#include "allegro.h"
#ifdef ZIG_GL
	#include "alleggl.h"
#endif


/* Fortified memory allocation. Reinforces the malloc() and free() functions.
   Only used when debugging.
*/
#ifdef DEBUGMODE
#include "fortify.h"
#endif

#include "multilang2.h"

/* Some macros to make sure everyone codes right - no offence :-P */

#define set_gfx_mode whoops_you_are_supposed_to_use_screen_dot_h

/* End of macros */


#ifdef DJGPP
#include <values.h>
#define MAXRAND MAXINT
#else
#define random rand
#define srandom srand
#define MAXRAND RAND_MAX
#endif



#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif

/* Coordinate system:

   Imagine looking at a map from one side.

   As you increase x, you move to the right.
   As you increase y, you move away from the map.
   As you increase z, you move upwards.

   Your angle on the map is 'theta'.
   You were facing in the direction theta = 0 when looking at the map.
   As you increase theta, you start to turn to the right.

   This coordinate system is easy to remember if you now imagine looking at
   the map from directly above. The map's x and y coordinate axes will match
   up with those of the screen.

   Below are some helpers to convert between theta values and cartesian
   vectors. (A cartesian vector consists of x and y; add these to a point's
   coordinates to move a point in the direction 'th'.) Use these helpers to
   avoid any possible confusion about the coordinate system.

   Note: you have to include math.h to use these!
*/
#define THETA(x, y) atan2((x), -(y))
#define XVECT(th) sin((th))
#define YVECT(th) (-cos((th)))

#define SIN45 0.7071067812

#define VIEW_ASPECT (4.0 / 3.0)

#define N_PLAYERS 4

#define INT(x) ((int)floor((x)))

#define RND(x) (random() * ((x) / (float)MAXRAND))

#define SQDIST3(x, y, z) ((x)*(x) + (y)*(y) + (z)*(z))
#define SQDIST2(x, y) ((x)*(x) + (y)*(y))
#define SQ(x) ((x)*(x))


/* The players' names. These are "Cat", "Duck", "Rabbit" and "Chipmunk". */
extern char *player_name[N_PLAYERS];
extern const char *player_orig_name[N_PLAYERS];

/* Global datafile. datafile.h contains object indices. */
#include "datafile.h"
#include "music.h"
extern DATAFILE *dat;
extern COLOR_MAP add_map;

/* Colours in the palette. Menus can use these. */
#define COLOUR_WHITE 2
#define COLOUR_GREEN 3

/* The main module must do the following (in this order):
   - Set the config file, "bomb.ini".
   - Load the datafile, "bomb.dat".
   - Load, or else create and save, various tables (see below).
   - Load all the levels. If this fails, exit. See level.h.

   - initialise_timeloop();
   - initialise_control();

   - Load the options (see options.h).

   It must save and/or shut down all these things in reverse order at the
   end.

   The tables required are as follows:

   - An RGB_MAP for the palette in the datafile. Only colours 1 to 239 must
     be mapped, so we use a duplicate palette with colours 240 to 255 set to
     black (equal to colour 1) in order to create this table. Only the first
     of any equal colours will be used, which is 1.

   - A set of partial colour maps for the explosions. create_explosion_map()
     in s_expp.h will create these.
*/


/* Global variables */
extern FONT *MenuFont, *LargeFont, *SmallFont;
extern BITMAP *PowerUpBox;
extern BITMAP *Controler[4];
extern RGB *GamePal;
extern BITMAP *Logo, *LogoBomb, *MiniBomb, *Logo2;
extern BITMAP *Pod[N_PLAYERS][8], *BloodyPod[N_PLAYERS][8];
extern BITMAP *StartLight[4];

#if defined N_POWERUP_ANIM_FRAMES && N_POWERUP_ANIM_FRAMES != 3
#error You need to change the numbers here
#endif
extern BITMAP *Powerup[][3];
extern BITMAP *Bomb[8];
extern BITMAP *MagBomb;

extern BITMAP *Portal[7];

extern BITMAP *LeftArrow, *RightArrow;

typedef struct Sample_t {
	SAMPLE *Explosion[2];
	SAMPLE *WallBang, 
		*MenuBeep1, *MenuBeep2, 
		*ErrorSound;
	SAMPLE *Warning, *Error;
	SAMPLE *Shift;
} Sample_t;

extern Sample_t Sample;

extern struct DUH *Music[4];
extern struct AL_DUH_PLAYER *adp;

extern struct RIPPLE_COLOURS water_colours;
extern struct RIPPLE_COLOURS acid_colours;
extern BITMAP *Animal[4];


/* These will be looked up in the datafile */
#define N_SURFACES      2
#define N_TEXTURES     10
#define N_BLOOD_LEVELS  3
#define N_DAMAGE_LEVELS 3
extern BITMAP *block_info[N_TEXTURES][N_SURFACES][N_BLOOD_LEVELS][N_DAMAGE_LEVELS];


#endif /* INCLUDED_MAIN_H */
