/*
 * Main_gui.cpp
 * Copyright (C) Matej Tyc 2007 <muna@stcomp.cz>
 *
 * Main_gui.cpp is is part of stereozoom2
 *
 * This program is free software;
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * stereozoom2 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with stereozoom2.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */


#include "Main_gui.h"
#include <sstream>

Main_window::Main_window():
	Dialog_main(NULL, -1, wxT("GSTEREOZOOM2"))
{
	Images_size[X] = Spin_images_x->GetValue();	Images_size[X] = 0;
	Images_size[Y] = Spin_images_y->GetValue(); Images_size[Y] = 0;

	wxSizer * Main_sizer;

	Main_sizer = this->GetSizer();
	Grid_images = (wxFlexGridSizer *)Main_sizer->GetItem((size_t)0)->GetSizer();

	Regroup_panels();
}

void Main_window::Regroup_panels()
{
	int spin_x = Spin_images_x->GetValue(),
		spin_y = Spin_images_y->GetValue();

	int DX = spin_x - Images_size[X],
		DY = spin_y - Images_size[Y];

	wxSizerFlags flags(1);
		flags.Expand();

	if (DY < 0)
	{//first remove Y-cropped panels
		int first_outside = Images_size[X] * spin_y;
		for (int i = first_outside; i < Images_size[X] * Images_size[Y]; i++)
		{
			wxWindow * panel = Grid_images->GetItem(first_outside)->GetWindow();
			Grid_images->Detach(first_outside);
			panel->Destroy();

		}
		for (int i = spin_y; i < Images_size[Y]; i++)
			Grid_images->RemoveGrowableRow(i);
		Grid_images->SetRows(spin_y);
	}

	if (DY > 0)
	{//or add some if they were not removed
		Grid_images->SetRows(spin_y);	//resizing the sizer first
		for (int i = Images_size[Y]; i < spin_y; i++)
			Grid_images->AddGrowableRow(i);
		// adding the panels
		for (int i = Images_size[X] * Images_size[Y]; i < Images_size[X] * spin_y; i++)
		{
			Image_panel * image = new Image_panel(this, i % Images_size[X], i / Images_size[X]);
			Grid_images->Add(image, flags);	//and to the sizer
		}
	}

	if (DX < 0)
	{
		int destroyed = 0;
		for (int i = 0; i < Images_size[X] * spin_y; i++)
			if ( (i % Images_size[X]) >= spin_x) //cropping from X
			{
				wxWindow * panel = Grid_images->GetItem(i - destroyed)->GetWindow();
				Grid_images->Detach(i - destroyed);
				panel->Destroy();
				destroyed++;
			}
		for (int i = spin_x; i < Images_size[X]; i++)
			Grid_images->RemoveGrowableCol(i);
		Grid_images->SetCols(spin_x);
	}

	if (DX > 0)
	{//placing new along X
		Grid_images->SetCols(spin_x);
		for (int i = Images_size[X]; i < spin_x; i++)
			Grid_images->AddGrowableCol(i);
		for (int i = 0; i < DX * spin_y; i++)
		{
			Image_panel * image = new Image_panel(this, i % spin_x, i / spin_x);
			int index = (i / DX) * spin_x + (i % DX) + spin_x - 1;
			Grid_images->Insert( index, image, flags);
		}
	}

	Images_size[X] = spin_x;
	Images_size[Y] = spin_y;

	Grid_images->Layout();
	this->GetSizer()->RecalcSizes();
	this->Fit();
}

void Main_window::Start_clicked( wxCommandEvent& event )
{
	std::stringstream command(std::stringstream::out);
	command << "-a\n" << Spinner_image_1->GetValue() << "x" << Spinner_image_2->GetValue() << "\n";
	command << "-m\n" << Spin_images_x->GetValue() << "," << Spin_images_y->GetValue() << "\n";

	Image_panel * impanel = 0;
	for (int i = 0; i < Spin_images_x->GetValue() * Spin_images_y->GetValue(); i++)
	{
		impanel = (Image_panel *)(Grid_images->GetItem(i)->GetWindow());
		if (impanel->Check_use->GetValue() == false)
			command << "-s\n1\n";
		else
		{
			impanel = (Image_panel *)(Grid_images->GetItem(i)->GetWindow());
			command << "-f\n" << impanel->Get_filename().mb_str() << "\n";
		}//endelse(impanel->Check_use->GetValue() == false)
	}

	stereozoom2(command.str().c_str());
}

void Main_window::About_clicked( wxCommandEvent& event )
{
	Dialog_about * about = new About_window(this);

	about->ShowModal();

	about->Destroy();
}

Image_panel::Image_panel(Main_window * parent, int x, int y):
	Panel_image((wxWindow *)parent, -1), Parent(parent)
{
	Coords[X] = x; Coords[Y] = y;
}

void Image_panel::Paint_image()
{
	wxPaintDC temp_DC(Image_space);
	if (Check_preview->GetValue() == false)
		return;	//preview is not wanted

	wxImage img_temp;

	img_temp = Image.Scale(Image_space->GetSize().GetWidth(), Image_space->GetSize().GetHeight());

	temp_DC.DrawBitmap(img_temp, 0, 0);
}

void Image_panel::Chosen_file( wxFileDirPickerEvent& event )
{
	Current_file = File_picker->GetPath();	// setting the current filename

	bool loaded = Image.LoadFile(Current_file);
	Refresh();
	if (!loaded)
	{// load unsuccesful
		wxMessageDialog(this, wxT("You won't see the image preview now since the format is not common. I just hope that you actually selected a valid image..."), wxT("Unusual format"), wxOK | wxICON_EXCLAMATION);
		return;
	}

	Check_use->SetValue(true);
}

void Image_panel::Toggle_preview( wxCommandEvent& event )
{

}

About_window::About_window(wxWindow * parent):
	Dialog_about(parent, -1)
{
}
