/*
 *	projekt
 *
 *	Created by Johan Halmn on 8.5.2008.
 *	Copyright (c) 2008 __MyCompanyName__. All rights reserved.
 */

#include <allegro.h>
#include "data.h"
#include "classes.h"
#include "dialogs.h"

DATAFILE *mydata;
cell *field;
int tcount, seccount;
bool breakdown;
BITMAP *buffer;
int totscore;
bool cell::flagged = false;
int cell::howmany = 8;

globals g;

void my_timer(void);
void my_second_timer(void);


int main(int argc, const char *argv[])
{
	BITMAP *pat;
	
	allegro_init();
	install_keyboard();
	install_timer();
	install_mouse();
	install_int(my_timer, 1);
	install_int(my_second_timer, 1000);
	install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "");
	srand(time(NULL));
	set_color_depth(32);
	if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0)) {
		allegro_message("Error setting 640x480x32 windowed gfx mode:\n%s\n", allegro_error);
		return -1;
	}
	set_window_title("Hexstones 0.5");
	set_close_button_callback(my_total_breakdown);
	breakdown = false;
	gui_mouse_focus = false;

    set_config_file("allegro.cfg");
    g.sfx_vol = get_config_int("SOUND", "sfx_vol", 255);
    g.music_vol = get_config_int("SOUND", "music_vol", 255);
    set_volume(g.sfx_vol, g.music_vol);
    g.left_key = get_config_int("CONTROLS", "left_key", KEY_J);
    g.right_key = get_config_int("CONTROLS", "right_key", KEY_L);
    g.rotate_key = get_config_int("CONTROLS", "rotate_key", KEY_K);
    g.down_key = get_config_int("CONTROLS", "down_key", KEY_M);
    set_color_conversion(COLORCONV_NONE);

	mydata = load_datafile("data.dat");
	clear_to_color(screen, makecol(255, 255, 255));
	if (!mydata)
	    textout_centre_ex(screen, font, "Failed with data file!", 160, 96, makecol(0, 0, 0), -1);
	pat = (BITMAP*)mydata[pattern].dat;
		
	// Create the field
	field = new cell[125];
	cell::create_field(field);
	buffer = create_bitmap(348, 466);
	
	show_intro_screen();
	
	
	int main_com;
    do
    {
        main_com = main_menu();
        switch (main_com)
        {
            case 1 :
                if (!breakdown)
                    do_game();
                break;
            case 2 :
                do_settings();
                break;
            case 3 :
                do_help();
                break;
            case 4 :
                do_scores();
                break;
            case 5 :
                do_extras();
                break;
        }
    }
    while (main_com != 6 && !breakdown);
    
    set_config_int("SOUND", "sfx_vol", g.sfx_vol);
    set_config_int("SOUND", "music_vol", g.music_vol);
    set_config_int("CONTROLS", "left_key", g.left_key);
    set_config_int("CONTROLS", "right_key", g.right_key);
    set_config_int("CONTROLS", "rotate_key", g.rotate_key);
    set_config_int("CONTROLS", "down_key", g.down_key);
        
	destroy_bitmap(buffer);
	unload_datafile(mydata);
	
	return 0;
}
END_OF_MAIN();

void my_timer(void)
{
    tcount--;
}

void my_second_timer(void)
{
    seccount--;
}


