#include <allegro.h>
#include "data.h"
#include "classes.h"
#include "myprocs.h"
#include "dialogs.h"

#define dummy_bmp NULL

extern DATAFILE* mydata;
extern globals g;

void settings_menu(void)
{
    int sfx_vol, m_vol;
    sfx_vol = g.sfx_vol;
    m_vol = g.music_vol;
    
    DIALOG dlg[] =
    {
       /* (proc)        (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc, 0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_mybox_proc, 58,   142,   160, 150, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_mybox_proc, 320,   142,   265, 150, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_mytextbox_proc,   70,  162, 96,  28,  -1,   -1, 0,    0,      0,   0,   (void*)"sound effects", NULL, NULL },
       { d_mytextbox_proc,   42,  222, 96,  28,  -1,   -1, 0,    0,      0,   0,   (void*)"music",         NULL, NULL },
       { d_slider_proc, 68,  182, 140, 12,  0,   0xdddddd, 0,    0,      140,  4,   NULL,                   (void*)my_slide_callback, (void*)1 },
       { d_slider_proc, 68,  242, 140, 12,  0,   0xdddddd, 0,    0,      140,  4,   NULL,                   (void*)my_slide_callback, (void*)2 },
       
       { d_keysetting_proc,   344, 208, 68,  20,  -1,   -1, 0,    0,      0,   0,   (void*)"text",          NULL, NULL },
       { d_keysetting_proc,   416, 208, 68,  20,  -1,   -1, 0,    0,      0,   0,   (void*)"text",          NULL, NULL },
       { d_keysetting_proc,   488, 208, 68,  20,  -1,   -1, 0,    0,      0,   0,   (void*)"text",          NULL, NULL },
       { d_keysetting_proc,   416, 256, 68,  20,  -1,   -1, 0,    0,      0,   0,   (void*)"text",          NULL, NULL },
       { d_mytextbox_proc,   400, 148, 96,  28,  -1,   -1, 0,    0,      0,   0,   (void*)"keys",          NULL, NULL },
       
       { d_mytextbox_proc,   344, 180, 60,  16,  -1,   -1, 0,    0,      0,   0,   (void*)"left",          NULL, NULL },
       { d_mytextbox_proc,   416, 180, 60,  16,  -1,   -1, 0,    0,      0,   0,   (void*)"shift",       NULL, NULL },
       { d_mytextbox_proc,   488, 180, 60,  16,  -1,   -1, 0,    0,      0,   0,   (void*)"right",         NULL, NULL },
       { d_mytextbox_proc,   416, 232, 60,  16,  -1,   -1, 0,    0,      0,   0,   (void*)"drop",          NULL, NULL },
       { d_icon_proc,   176, 376, 136, 36,  0,   0,        0,    D_EXIT,      0,   0,   dummy_bmp,              NULL, NULL },
       
       { d_icon_proc,   328, 376, 136, 36,  0,   0,        0,    D_EXIT,      0,   0,   dummy_bmp,              NULL, NULL },
       { d_mybitmap_proc, 172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   dummy_bmp,              NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,        0,    0,      0,   0,   NULL,                   NULL, NULL }
    };
    show_mouse(screen);
    set_palette((RGB*)mydata[mediumfontpal].dat);
    font = (FONT*)mydata[mediumfont].dat;
    myicon *ok_button = new myicon((BITMAP*)mydata[pattern3].dat, "Ok", 136, 36);
    myicon *cancel_button = new myicon((BITMAP*)mydata[pattern3].dat, "Cancel", 136, 36);
    
    dlg[0].dp = mydata[pattern2].dat;
    dlg[18].dp = mydata[settings_plate].dat;
    // key settings
    dlg[7].d1 = g.left_key;
    dlg[8].d1 = g.rotate_key;
    dlg[9].d1 = g.right_key;
    dlg[10].d1 = g.down_key;
    // sound settings
    dlg[5].d2 = 140*g.sfx_vol / 255;
    dlg[6].d2 = 140*g.music_vol / 255;
    
    
    dlg[16].dp = (void*)ok_button->bm1;
    dlg[16].dp2 = (void*)ok_button->bm0;
    dlg[17].dp = (void*)cancel_button->bm1;
    dlg[17].dp2 = (void*)cancel_button->bm0;
    
    set_alpha_blender();
    gui_fg_color = -1;
    gui_bg_color = -1;
    if (do_dialog(dlg, -1) == 16)
    {
        g.left_key = dlg[7].d1;
        g.rotate_key = dlg[8].d1;
        g.right_key = dlg[9].d1;
        g.down_key = dlg[10].d1;
        
        g.sfx_vol = 255 * dlg[5].d2 / 140;
        g.music_vol = 255 * dlg[6].d2 / 140; // Either set the new volumes
        set_volume(g.sfx_vol, g.music_vol);
    }
    else
        set_volume(sfx_vol, m_vol);          // or restore the old ones, if 
                                             // Cancel was pressed. The user 
                                             // may have messed with the sliders.
        
    
    delete ok_button;
    delete cancel_button;
    show_mouse(NULL);
}

int main_menu(void)
{

        DIALOG main_dialog[] =
    {
       /* (proc)        (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)       (dp2) (dp3) */
       { d_myfill_proc, 0,   0,   640, 480, 0,   0,   0,    0,      0,   0,   dummy_bmp, NULL, NULL },
       { d_mybitmap_proc, 172, 4,   296, 116, 0,   0,   0,    0,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 132, 136, 36,  0,   0,   0,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 188, 136, 36,  0,   0,   0,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 244, 136, 36,  0,   0,   0,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 300, 136, 36,  0,   0,   0,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 356, 136, 36,  0,   0,   0,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { d_icon_proc,   252, 412, 136, 36,  0,   0,   27,    D_EXIT,      0,   0,   dummy_bmp, NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    show_mouse(screen);
    set_palette((RGB*)mydata[mediumfontpal].dat);
    font = (FONT*)mydata[mediumfont].dat;
    
    main_dialog[0].dp = mydata[pattern2].dat;
    main_dialog[1].dp = mydata[main_menu_plate].dat;
    myicon play_butt((BITMAP*)mydata[pattern3].dat, "Play", 136, 36);
    myicon settings_butt((BITMAP*)mydata[pattern3].dat, "Settings", 136, 36);
    myicon help_butt((BITMAP*)mydata[pattern3].dat, "Help", 136, 36);
    myicon scores_butt((BITMAP*)mydata[pattern3].dat, "Scores", 136, 36);
    myicon extras_butt((BITMAP*)mydata[pattern3].dat, "Extras", 136, 36);
    myicon quit_butt((BITMAP*)mydata[pattern3].dat, "Quit", 136, 36);
    
    main_dialog[2].dp = play_butt.bm1;
    main_dialog[2].dp2 = play_butt.bm0;
    main_dialog[3].dp = settings_butt.bm1;
    main_dialog[3].dp2 = settings_butt.bm0;
    main_dialog[4].dp = help_butt.bm1;
    main_dialog[4].dp2 = help_butt.bm0;
    main_dialog[5].dp = scores_butt.bm1;
    main_dialog[5].dp2 = scores_butt.bm0;
    main_dialog[6].dp = extras_butt.bm1;
    main_dialog[6].dp2 = extras_butt.bm0;
    main_dialog[7].dp = quit_butt.bm1;
    main_dialog[7].dp2 = quit_butt.bm0;
    
    return do_dialog(main_dialog, -1) - 1; // First choice is 1, that is "Play"
    
}

void myalert(char *t1, char *t2, char *t3, char *t4, char *t5, int a, int b)
{
    set_palette((RGB*)mydata[mediumfontpal].dat);
    font = (FONT*)mydata[mediumfont].dat;
    myicon closebutt((BITMAP*)mydata[pattern3].dat, t5, 136, 36);
    set_palette((RGB*)mydata[smallfontpal].dat);
    DIALOG thealert[] =
    {
       /* (proc)        (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)       (dp2) (dp3) */
       {  d_bitmap_proc,   192, 64,  256, 384, 0x000000, 0x80f0b0, 0, 0, 0, 0,   mydata[alertbkg].dat,      NULL, NULL},
       {  d_text_proc,  217, 96,  195,  39, -1,   -1, 0,     0,     0,    0,  (void*)t1, mydata[mediumfont].dat, NULL },
       {  d_text_proc,  217, 145,  195,  24, -1,   -1, 0,     0,     0,    0,  (void*)t2, mydata[smallfont].dat, NULL },
       {  d_text_proc,  217, 175,  195,  24, -1,   -1, 0,     0,     0,    0,  (void*)t3, mydata[smallfont].dat, NULL },
       {  d_text_proc,  217, 205,  195,  24, -1,   -1, 0,     0,     0,    0,  (void*)t4, mydata[smallfont].dat, NULL },
       {  d_icon_proc,   252, 306, 136, 36,  0,   0,   13,    D_EXIT,      0,   0,   closebutt.bm1, closebutt.bm0, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    popup_dialog(thealert, -1);
}
       
void help_menu(void)
{
    set_palette((RGB*)mydata[mediumfontpal].dat);
    font = (FONT*)mydata[minifont].dat;
    myicon left((BITMAP*)mydata[pattern3].dat, "<", 20, 20);
    myicon right((BITMAP*)mydata[pattern3].dat, ">", 20, 20);
    myicon ret((BITMAP*)mydata[pattern3].dat, "Return", 40, 20);
    
    
    
    
    char *help1 = 
        "Try to get three or more stones of same colour in a row by moving the falling block sideways "
        "or shifting the order of the three stones in the falling block.\n"
        "When you achieve that, the row gets deleted and the pile of stones shrink.\n\n"
        "You can also try to form a hexagon out of six stones of same colour. When you achieve that, "
        "the whole hexagon gets deleted, including the seventh stone in the middle.";
    char *help2 =
        "In each level you have a given number of:\n * time\n * stones to collect\n * different stones\n\n"
        "If you complete the level, you get scores according to the amount of time left.\n"
        "If you get more than three stones deleted in one turn, you get bonus points. For "
        "each hexagon you get some bonus time. In some levels you really need the bonus time, "
        "but even if you don't need it, it raises your score when you complete the level.";
    char *help3 =
        "There are some special stones that may appear in some levels. The rainbow coloured stone "
        "acts as a wildcard and matches with all others except the black stone. The black stones "
        "don't get deleted when three in row, but you can build a hexagon with them. Three white "
        "stones in a row make all black stones disappear.\n\n"
        "The rainbow stones don't work with hexagons, nor with white stones (what comes to deleting "
        "black stones). But one rainbow stone "
        "can act with more than one colour in one turn.";
    char *help4 =
        "The number of stones that is deleted in one turn affects your score. Three stones give you "
        "nothing, four give 12 points, five give 20 points. The points grow exponentially. But if "
        "three stones are deleted, then the piles fall down, then three more stones get deleted, "
        "it counts as two turns with three stones in each, giving you no points!\n\n"
        "The easiest way to build hexagons is probably like in the image to the right. You need two "
        "blocks with two stones of same colours, then two blocks with one stone with same colour.";
    char *help4_1 =
        "The last block has to be shifted once to make the hexagon, "
        "otherwise you just get a three in row.";
        
    char *help5 =
        "The Settings menu allows you to set the volume for both sound effects and the music. "
        "It allows you to set the keys, too. Click in a field and then press the desired key to "
        "change it. All changes will be saved in the cfg file. So far there's no error checking "
        "with what keys you set. I've no idea what happens if you mess with them.\n\n"
        "If you have problems with sound, try to turn the music volume all the way down."
        ;

    char *help6 =
        "Creator: Johan Halmen\n"
        "Web page: http://mail.loviisa.fi/\n"
        "              ~jhalmen/projects/hexstones\n"
        "Used software:\n"
        " * Xcode and Dev-Cpp\n"
        " * gcc and Mingw\n"
        " * Allegro library\n"
        " * Logic Express and Logic Fun\n"
        " * Gimp and Inkscape\n\n"
        "Coming up soon:\n"
        " * source code\n"
        " * Macintosh version\n";
        
    DIALOG page1[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   335, 280, -1,   0xdddddd,        0,    0,      0,   0,   help1,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_DISABLED,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   right.bm1, right.bm0, right.bmx },
       { d_mybitmap_proc, 400, 152, 64, 89,  0,   0,   0,     0,      0,   0,   mydata[help11].dat, NULL, NULL },
       { d_mybitmap_proc, 464, 172, 49, 137,  0,   0,   0,     0,      0,   0,   mydata[help12].dat, NULL, NULL },
       { d_mybitmap_proc, 410, 252, 65, 101,  0,   0,   0,     0,      0,   0,   mydata[help13].dat, NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    DIALOG page2[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   335, 280, -1,   0xdddddd,        0,    0,      0,   0,   help2,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   right.bm1, right.bm0, right.bmx },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    DIALOG page3[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   335, 280, -1,   0xdddddd,        0,    0,      0,   0,   help3,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   right.bm1, right.bm0, right.bmx },
       { d_mybitmap_proc, 410, 252, 67, 98,  0,   0,   0,     0,      0,   0,   mydata[help31].dat, NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    DIALOG page4[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   335, 280, -1,   0xdddddd,        0,    0,      0,   0,   help4,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   right.bm1, right.bm0, right.bmx },
       { d_mybitmap_proc, 400, 152, 67, 159,  0,   0,   0,     0,      0,   0,   mydata[help41].dat, NULL, NULL },
       { d_mybitmap_proc, 447, 170, 67, 159,  0,   0,   0,     0,      0,   0,   mydata[help42].dat, NULL, NULL },
       { d_textbox_proc,    400,   329,   170, 103, -1,   0xdddddd,        0,    0,      0,   0,   help4_1,              NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    

    DIALOG page5[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   520, 280, -1,   0xdddddd,        0,    0,      0,   0,   help5,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   right.bm1, right.bm0, right.bmx },
       //{ d_mybitmap_proc, 432, 171, 140, 140,  0,   0,   0,     0,      0,   0,   mydata[magicoink1].dat, NULL, NULL },
       //{ d_mybitmap_proc, 343, 319, 231, 107,  0,   0,   0,     0,      0,   0,   mydata[pbalogo].dat, NULL, NULL },
       //{ d_mybitmap_proc, 439, 332, 65, 101,  0,   0,   0,     0,      0,   0,   mydata[alec1].dat, NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    
    DIALOG page6[] =
    {
       /* (proc)             (x)  (y)  (w)  (h)  (fg) (bg)      (key) (flags) (d1) (d2) (dp)                    (dp2) (dp3) */
       { d_myfill_proc,       0,   0,   640, 480, 0xcc88aa,   0,        0,    0,      0,   0,   mydata[pattern2].dat,              NULL, NULL },
       { d_mybitmap_proc,    172, 4,   296, 116, 0,   0,        0,    0,      0,   0,   mydata[help_plate].dat,              NULL, NULL },
       { d_mybox_proc,        50,   142,   540, 300, 0xdddddd,   0,        0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc,    60,   152,   520, 280, -1,   0xdddddd,        0,    0,      0,   0,   help6,              NULL, NULL },
       { d_icon_proc,   270, 450, 20, 20,  0,   0,   0,    D_EXIT,      0,   0,   left.bm1, left.bm0, left.bmx },
       { d_icon_proc,   300, 450, 40, 20,  0,   0,   0,    D_EXIT,      0,   0,   ret.bm1, ret.bm0, ret.bmx },
       { d_icon_proc,   350, 450, 20, 20,  0,   0,   0,    D_DISABLED,      0,   0,   right.bm1, right.bm0, right.bmx },
       { d_mybitmap_proc, 432, 171, 140, 140,  0,   0,   0,     0,      0,   0,   mydata[magicoink1].dat, NULL, NULL },
       { d_mybitmap_proc, 343, 319, 231, 107,  0,   0,   0,     0,      0,   0,   mydata[pbalogo].dat, NULL, NULL },
       { d_mybitmap_proc, 439, 332, 65, 101,  0,   0,   0,     0,      0,   0,   mydata[alec1].dat, NULL, NULL },
       { NULL,          0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,      NULL, NULL }
    };    
    

    DIALOG *dlg[] = {page1, page2, page3, page4, page5, page6};
    int p, com;
    p = 0;
    font = (FONT*)mydata[smallfont].dat;
    set_palette((RGB*)mydata[smallfontpal].dat);
    do
    {
        com = do_dialog(dlg[p], -1);
        if (com == 4) p--;
        if (com == 6) p++;
    }
    while (com != 5);
        
        
        
}

void show_intro_screen(void)
{
    BITMAP *mask;
    BITMAP *buffer, *buffer2;
    int brown, i, j, k;
    mask = create_bitmap_ex(8, 535, 273);
    buffer = create_bitmap(535, 273);
    buffer2 = create_bitmap(535, 273);
    clear_bitmap(screen);
    brown = getpixel((BITMAP*)mydata[titlepattern2362].dat, 0, 0);
    bool escape = false;
    // rotate plate
    for (i = 0; i < 100 && !escape; i += 2)
    {
        if (keypressed())
            escape = true;
        clear_to_color(buffer, 0);
        clear_to_color(mask, 0);
        clear_to_color(buffer, brown);
        if (i >87 && i < 97)
            clear_to_color(buffer, makecol(255, 255, 255));
        else
        for (j = 0, k = 500-4*i; j < buffer->h; j += 61, k -= 23)
            draw_sprite(buffer, (BITMAP*)mydata[titlepattern2362].dat, k, j);
        clear_to_color(mask, 1);
        stretch_blit((BITMAP*)mydata[titlemask].dat, mask, 0, 0, 535, 273, 268-268*i/99, 0, 535*i/99, 273);
        //stretch_blit((BITMAP*)mydata[titlemask].dat, mask, 0, 0, 535, 273, 0, 0, 535, 273);
        //blit((BITMAP*)mydata[titlemask].dat, mask, 0, 0, 0, 0, 535, 273);
        
        set_write_alpha_blender();
        draw_trans_sprite(buffer, mask, 0, 0);
        set_alpha_blender();
        clear_bitmap(buffer2);
        draw_trans_sprite(buffer2, buffer, 0, 0);
        draw_sprite(screen, buffer2, 52, 40);
        //rest(1);
    }
    // rotate plate /
    
    // magic oink
    if (!escape)
    {
        blit((BITMAP*)mydata[magicoink1].dat, screen, 0, 0, 25, 315, 140, 140);
        rest(750);
        blit((BITMAP*)mydata[magicoink2].dat, screen, 0, 0, 25, 315, 140, 140);
        rest(70);
        blit((BITMAP*)mydata[magicoink1].dat, screen, 0, 0, 25, 315, 140, 140);
        rest(100);
        blit((BITMAP*)mydata[magicoink2].dat, screen, 0, 0, 25, 315, 140, 140);
        rest(70);
        blit((BITMAP*)mydata[magicoink1].dat, screen, 0, 0, 25, 315, 140, 140);
    }
    rest(350);
    
    // alex
    BITMAP *buff;
    buff = create_bitmap(231, 107);
    if (!escape)
    {
        set_alpha_blender();
        blit((BITMAP*)mydata[pbalogo].dat, screen, 0, 0, 383, 348, 231, 107);
        rest(750);
        for (int i = 231; !escape && i >= 96; i-=5)
        {
            blit((BITMAP*)mydata[pbalogo].dat, buff, 0, 0, 0, 0, 231, 107);
            draw_trans_sprite(buff, (BITMAP*)mydata[alec1].dat, i, 13-4*(i%2));
            blit(buff, screen, 0, 0, 383, 348, 231, 107);
            if (keypressed())
                escape = true;
            rest(5);
        }
        if (!escape && !keypressed())
            rest(750);
    
        blit((BITMAP*)mydata[pbalogo].dat, buff, 0, 0, 0, 0, 231, 107);
        draw_trans_sprite(buff, (BITMAP*)mydata[alec2].dat, 96, 13);
        blit(buff, screen, 0, 0, 383, 348, 231, 107);
        if (!escape)
            rest(100);
        
        blit((BITMAP*)mydata[pbalogo].dat, buff, 0, 0, 0, 0, 231, 107);
        draw_trans_sprite(buff, (BITMAP*)mydata[alec3].dat, 96, 13);
        blit(buff, screen, 0, 0, 383, 348, 231, 107);
        if (!escape)
            rest(300);
        
        blit((BITMAP*)mydata[pbalogo].dat, buff, 0, 0, 0, 0, 231, 107);
        draw_trans_sprite(buff, (BITMAP*)mydata[alec2].dat, 96, 13);
        blit(buff, screen, 0, 0, 383, 348, 231, 107);
        if (!escape)
            rest(100);
        
        blit((BITMAP*)mydata[pbalogo].dat, buff, 0, 0, 0, 0, 231, 107);
        draw_trans_sprite(buff, (BITMAP*)mydata[alec1].dat, 96, 13);
        blit(buff, screen, 0, 0, 383, 348, 231, 107);
    }
        
    destroy_bitmap(buff);
    //231  107 pixels
    
    if (!escape)
        readkey();
    clear_keybuf();
}

int my_slide_callback(void *dp3, int d2)
{
    int vol;
    static int voice = -1;
    if (int(dp3) == 1) // SFX Volume
    {
        vol = 255 * d2 / 140;
        set_volume(vol, -1);
        if (voice_get_position(voice) == -1)
            voice = play_sample((SAMPLE*)mydata[volcontrol].dat, 255, 128, 1000, 0);
    }
    
    if (int(dp3) == 2) // Music Volume
    {
        vol = 255 * d2 / 140;
        set_volume(-1, vol);
        play_midi((MIDI*)mydata[shorty].dat, 0);
    }
    
    return D_O_K;
}
