#include <fstream> ///
#include <allegro.h>
#include "classes.h"
#include "data.h"
#include "stdio.h"
#include "dialogs.h"

#define SFX_VOL 255

/*
 gem01 red
 gem02 yellow
 gem03 green
 gem04 violet
 gem05 brown
 gem06 turquoise
 gem07 rainbow
 gem08 black
 gem09 white
*/
//using namespace std;
extern DATAFILE *mydata;
extern BITMAP *buffer;
extern int tcount;
extern int seccount;
extern cell *field;
extern bool breakdown;
extern int totscore;
extern globals g;

int cell::next1 = 1;
int cell::next2 = 2;
int cell::next3 = 3;
bool cell::flag_blacks;
int ticktack_id;

std::ofstream myfile;

void cell::draw_all(BITMAP *where, cell *f)
{
    blit((BITMAP*)mydata[backgr1].dat, buffer, 0, 0, 0, 0, 348, 466);	
	for (int i = 0; i < 125; i++)
	    f[i].draw(buffer);
	vsync();
	blit(buffer, where, 0, 0, 0, 0, 348, 466);
}

void my_total_breakdown(void)
{
    // several escape presses eventually
    // shuts down the whole application
    
    simulate_ukeypress(27, 0);
    simulate_ukeypress(27, 0);
    simulate_ukeypress(27, 0);
    simulate_ukeypress(27, 0);
    
    // set a quit-game-flag, just in case
    breakdown = true;
}

int cell::move_down(cell *f)
{
    if (f->neighbour[3] == NULL)
	    return 0;
	if (f->neighbour[3]->type != 0)
	    return 0;
	
	// move one down
	f->neighbour[3]->type = f->type;
	f->type = f->neighbour[0]->type;
	f->neighbour[0]->type = f->neighbour[0]->neighbour[0]->type;
	f->neighbour[0]->neighbour[0]->type = 0;
	//*f = &f->neighbour[3];
	return 1;
}

void cell::set_flag(cell *f, int n)
{
    for (int i = 0; i < 125; i++)
	{
	    f[i].flag = n;
	}
}

int cell::move_left(cell *f)
{
    if (f->neighbour[4] == NULL)
	    return 0;
	if (f->neighbour[4]->type != 0)
	    return 0;

	// move one down
	f->neighbour[4]->type = f->type;
	f->type = 0;
	f->neighbour[5]->type = f->neighbour[0]->type;
	f->neighbour[0]->type = 0;
	f->neighbour[5]->neighbour[0]->type = f->neighbour[0]->neighbour[0]->type;
	f->neighbour[0]->neighbour[0]->type = 0;
	return 1;
}

cell *cell::start(cell *f, int sc)
{
    if (f[58].type != 0)
	    return NULL;
	f[56].type = next1;
    f[57].type = next2;
    f[58].type = next3;
    	
	int check[9], max;
    do
	{
	    for (int i = 0; i < 9; check[i] = 0, i++);
        next1 = rand() %sc + 1;
		check[next1-1]++;
        next2 = rand() %sc + 1;
		check[next2-1]++;
        next3 = rand() %sc + 1;
        check[next3-1]++;
        max = 0;
        for (int i = 0; i < 9; i++)
            if (check[i]>max)
                max = check[i];
	}
	while (max == 3 || (max == 2 && check[6] == 1) || check[6] == 2);
	
	blit((BITMAP*)mydata[backgr1].dat, screen, 358, 169, 358, 169, 52, 113);
	draw_trans_sprite(screen, (BITMAP*)mydata[gem01+next1-1].dat, 367, 180);
	draw_trans_sprite(screen, (BITMAP*)mydata[gem01+next2-1].dat, 367, 212);
	draw_trans_sprite(screen, (BITMAP*)mydata[gem01+next3-1].dat, 367, 244);
	
	clear_keybuf();
    return &f[58];
}
		   
void print_time(void)
{
    static int oldtime;
    if (seccount != oldtime)
    {
        blit((BITMAP*)mydata[backgr1].dat, buffer, 448, 203, 0, 0, 91, 46);
        textprintf_ex(buffer, (FONT*)mydata[bigfont].dat, 10, 5, -1, -1, "%d", seccount);
        blit(buffer, screen, 0, 0, 448, 203, 91, 46);
        oldtime = seccount;
        if (seccount == 10)
        {
            play_sample((SAMPLE*)mydata[tenseconds].dat, SFX_VOL, 128, 1000, 0);
            ticktack_id = play_sample((SAMPLE*)mydata[ticktack].dat, SFX_VOL, 128, 700, 1);
        }
        if (seccount <= 5)
        {
            play_sample((SAMPLE*)mydata[fiveseconds].dat, SFX_VOL, 128, 1000, 0);
        }
    }
    
}

void print_score(void)
{
    static int oldscore=-1;
    if (totscore != oldscore)
    {
        blit((BITMAP*)mydata[backgr1].dat, buffer, 448, 377, 0, 0, 162, 46);
        textprintf_ex(buffer, (FONT*)mydata[bigfont].dat, 10, 5, -1, -1, "%d", totscore);
        blit(buffer, screen, 0, 0, 448, 377, 162, 46);
        oldscore = totscore;
    }
    
}

void print_stones(int stones)
{
    static int oldstones;
    if (stones != oldstones)
    {
        blit((BITMAP*)mydata[backgr1].dat, buffer, 448, 290, 0, 0, 91, 46);
        textprintf_ex(buffer, (FONT*)mydata[bigfont].dat, 10, 5, -1, -1, "%d", stones);
        blit(buffer, screen, 0, 0, 448, 290, 91, 46);
        oldstones = stones;
    }
    
}

int cell::move_right(cell *f)
{
    if (f->neighbour[2] == NULL)
	    return 0;
	if (f->neighbour[2]->type != 0)
	    return 0;
	
	// move one down
	f->neighbour[2]->type = f->type;
	f->type = 0;
	f->neighbour[1]->type = f->neighbour[0]->type;
	f->neighbour[0]->type = 0;
	f->neighbour[1]->neighbour[0]->type = f->neighbour[0]->neighbour[0]->type;
	f->neighbour[0]->neighbour[0]->type = 0;
	return 1;
}

int cell::check_rings(cell *f)
{
    flagged = false;
    set_flag(f, 0);
    // column 0			
	for (int i = 0; i < 9; i++)
	    f[i].check_ring();
	// column 1
	for (int i = 10; i < 19; i++)
	    f[i].check_ring();
					
	// column 2
	for (int i = 21; i < 31; i++)
	    f[i].check_ring();
					
	// column 3
	for (int i = 32; i < 42; i++)
	    f[i].check_ring();
	
	// column 4
	for (int i = 44; i < 55; i++)
	    f[i].check_ring();
	
	// column 5, middle column
	for (int i = 57; i < 67; i++)
	    f[i].check_ring();
	
	// column 6
	for (int i = 70; i < 80; i++)
	    f[i].check_ring();
	
	// column 7
	for (int i = 82; i < 91; i++)
	    f[i].check_ring();
	
	// column 8
	for (int i = 94; i < 103; i++)
	    f[i].check_ring();
    
	int n = 0;
	// count empties and drop down
	if (flagged)
	{
        play_sample((SAMPLE*)mydata[ringsound].dat, SFX_VOL, 128, 1000, 0);
        cell::draw_all(screen, f);
        stop_sample((SAMPLE*)mydata[tenseconds].dat);

        rest(400);
        tcount += 400;
    }
	for (int i = 0; i < 125; i++)
	{
	    if (f[i].flag == 2)
		{
		    
			n++;
			drop_down(&f[i]);
		}
	}
	set_flag(f, 0);
	if (flagged)
	{
        cell::draw_all(screen, f);
        rest(400);
        tcount += 400;
    }
	return n;
}    

void cell::check_ring(void)
{
    if (type == 0)
        return;
    if (type != neighbour[1]->type)
        return;
    if (type != neighbour[1]->neighbour[2]->type)
        return;
    if (type != neighbour[2]->neighbour[2]->type)
        return;
    if (type != neighbour[3]->type)
        return;
    if (type != neighbour[3]->neighbour[2]->type)
        return;
    flag = 2;
    flagged = true;
    neighbour[1]->flag = 2;
    neighbour[1]->neighbour[2]->flag = 2;
    neighbour[2]->neighbour[2]->flag = 2;
    neighbour[3]->flag = 2;
    neighbour[3]->neighbour[2]->flag = 2;
    neighbour[2]->flag = 2;
}

        
int cell::check_triplets(cell *f)
{
    
    flag_blacks = false;
    flagged = false;	
	set_flag(f, 0);	
	for (int i = 0; i < 104; i++)
	{
	    check_triplet(&f[i], 1);
		check_triplet(&f[i], 2);
		check_triplet(&f[i], 3);
	    check_triplet(&f[i], 4);
		check_triplet(&f[i], 5);
		check_triplet(&f[i], 0);
	}
	for (int i = 104; i < 125; i++)
	{
	    check_triplet(&f[i], 0);
        check_triplet(&f[i], 3);
        check_triplet(&f[i], 4);
        check_triplet(&f[i], 5);
    }
    
	int n = 0;
	// count empties and drop down
	if (flagged)
	{
        play_sample((SAMPLE*)mydata[triadsound].dat, SFX_VOL, 128, 1000, 0);
        cell::draw_all(screen, f);
        rest(400);
        tcount += 400;
    }
	for (int i = 0; i < 125; i++)
	{
	    if (f[i].flag == 1 || (flag_blacks && f[i].type == 8))
		{
		    
			n++;
			drop_down(&f[i]);
		}
	}
	set_flag(f, 0);
	if (flagged)
	{
        cell::draw_all(screen, f);
        rest(400);
        tcount += 400;
    }
	return n;
}

void cell::drop_down(cell *f)
{
	do
	{
	    if (f->neighbour[0] == NULL || f->neighbour[0]->type == 0)
		{
		    f->type = 0;
		    return;
		}
		f->type = f->neighbour[0]->type;
		f = f->neighbour[0];
	}
	while (1);
}

void cell::check_triplet(cell *f, int neighb)
{
    if (f->type == 7 || f->type == 8)
	    return; // rainbow or black won't count
    if (f->type == 0) return;
	if (f->neighbour[neighb] == NULL) return;
	if (f->neighbour[neighb]->type != f->type && f->neighbour[neighb]->type != 7) return;
	if (f->neighbour[neighb]->neighbour[neighb] == NULL) return;
	if (f->neighbour[neighb]->neighbour[neighb]->type != f->type && f->neighbour[neighb]->neighbour[neighb]->type != 7) return;
	f->flag = 1;
	flagged = true;
	f->neighbour[neighb]->flag = 1;
	f->neighbour[neighb]->neighbour[neighb]->flag = 1;
	if (f->type == 9 && f->neighbour[neighb]->type == 9 && f->neighbour[neighb]->neighbour[neighb]->type == 9)
        flag_blacks = true;	
}
	
void cell::empty(cell *f)
{
    for (int i = 0; i < 125; i++)
        f[i].type = 0;
}	
	
void cell::create_field(cell *f)
{
    int x0, y0;
	int count;
	
	x0 = 22; y0 = 121;
	count = 0;

	for (int i = 0; i < 6; i++)
		for (int j = 0; j < 10+(i+1)/2; j++)
		{
			// if (rand()%10) draw_trans_sprite(screen, (BITMAP*)mydata[gem01 + rand() % 9].dat, 22+28*i, 121+32*j-16*i);
			f[count].x = x0 + 28*i;
			f[count].y = y0 + 32*j-16*i;
			f[count].type = 0;
			count++;
			
		}
		
			for (int i = 6; i < 11; i++)
				for (int j = 0; j <= 14-i/2;  j++)
				{
					f[count].x = x0 + 28*i;
					f[count].y = -39+32*j+16*i;
					f[count].type = 0;
					count++;
				}
	
	// column 0			
	for (int i = 0; i < 10; i++)
	{
	    if (i > 0)
		    f[i].neighbour[0] = &f[i-1];
		else
		    f[i].neighbour[0] = NULL;
		f[i].neighbour[1] = &f[i+10];
		f[i].neighbour[2] = &f[i+11];
		if (i < 9)
		    f[i].neighbour[3] = &f[i+1];
		else
		    f[i].neighbour[3] = NULL;
		f[i].neighbour[4] = NULL;
		f[i].neighbour[5] = NULL;
	}
	
	// column 1
	for (int i = 10; i < 21; i++)
	{
	    if (i > 10)
		{
		    f[i].neighbour[0] = &f[i-1];
			f[i].neighbour[5] = &f[i-11];
		}
		else
		{
		    f[i].neighbour[0] = NULL;
		    f[i].neighbour[5] = NULL;
		}
		
		f[i].neighbour[1] = &f[i+11];
		
		if (i < 20)
		{
		    f[i].neighbour[2] = &f[i+12];
			f[i].neighbour[3] = &f[i+1];
			f[i].neighbour[4] = &f[i-10];
		}
		else
		{
		    f[i].neighbour[2] = NULL;
		    f[i].neighbour[3] = NULL;
		    f[i].neighbour[4] = NULL;
		}
	}
					
	// column 2
	for (int i = 21; i < 32; i++)
	{
		if (i > 21)
		{
			f[i].neighbour[0] = &f[i-1];
			f[i].neighbour[5] = &f[i-12];
		}
		else
		{
			f[i].neighbour[0] = NULL;
			f[i].neighbour[5] = NULL;
		}
						
		f[i].neighbour[1] = &f[i+11];
		f[i].neighbour[2] = &f[i+12];
		f[i].neighbour[4] = &f[i-11];
					
		if (i < 31)
		{
			f[i].neighbour[3] = &f[i+1];
		}
		else
		{
			f[i].neighbour[3] = NULL;
			
		}
	}
					
					// column 3
					for (int i = 32; i < 44; i++)
					{
						if (i > 32)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[5] = &f[i-12];
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[5] = NULL;
						}
						
						f[i].neighbour[1] = &f[i+12];
						
						if (i < 43)
						{
							f[i].neighbour[2] = &f[i+13];
							f[i].neighbour[3] = &f[i+1];
							f[i].neighbour[4] = &f[i-11];
						}
						else
						{
							f[i].neighbour[2] = NULL;
							f[i].neighbour[3] = NULL;
							f[i].neighbour[4] = NULL;
						}
					}
					
					// column 4
					for (int i = 44; i < 56; i++)
					{
						if (i > 44)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[5] = &f[i-13];
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[5] = NULL;
						}
						
						f[i].neighbour[1] = &f[i+12];
						f[i].neighbour[2] = &f[i+13];
						f[i].neighbour[4] = &f[i-12];
						
						if (i < 55)
						{
							f[i].neighbour[3] = &f[i+1];
						}
						else
						{
							f[i].neighbour[3] = NULL;
							
						}
					}
					
					// column 5, middle column
					for (int i = 56; i < 69; i++)
					{
						if (i > 56)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[1] = &f[i+12];
							f[i].neighbour[5] = &f[i-13];
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[1] = NULL;
							f[i].neighbour[5] = NULL;
						}
						
						if (i < 68)
						{
							f[i].neighbour[2] = &f[i+13];
							f[i].neighbour[3] = &f[i+1];
							f[i].neighbour[4] = &f[i-12];
						}
						else
						{
							f[i].neighbour[2] = NULL;
							f[i].neighbour[3] = NULL;
							f[i].neighbour[4] = NULL;
														
						}
					}
					
					// column 6
					for (int i = 69; i < 81; i++)
					{
						if (i > 69)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[1] = &f[i+11];
							
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[1] = NULL;
							
						}
						
						f[i].neighbour[2] = &f[i+12];
						f[i].neighbour[4] = &f[i-12];
						f[i].neighbour[5] = &f[i-13];
						
						
						if (i < 80)
						{
							f[i].neighbour[3] = &f[i+1];
						}
						else
						{
							f[i].neighbour[3] = NULL;
						}
						
					}
					
					// column 7
					for (int i = 81; i < 93; i++)
					{
						if (i > 81)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[1] = &f[i+11];
							
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[1] = NULL;
							
						}
						
						f[i].neighbour[5] = &f[i-12];
						
						
						if (i < 92)
						{
							f[i].neighbour[2] = &f[i+12];
							f[i].neighbour[3] = &f[i+1];
							f[i].neighbour[4] = &f[i-11];
						}
						else
						{
							f[i].neighbour[2] = NULL;
							f[i].neighbour[3] = NULL;
							f[i].neighbour[4] = NULL;
						}
						
					}
					
					// column 8
					for (int i = 93; i < 104; i++)
					{
						if (i > 93)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[1] = &f[i+10];
							
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[1] = NULL;
							
						}
						
						f[i].neighbour[2] = &f[i+11];
						f[i].neighbour[4] = &f[i-11];
						f[i].neighbour[5] = &f[i-12];
						
						
						if (i < 103)
						{
							f[i].neighbour[3] = &f[i+1];
						}
						else
						{
							f[i].neighbour[3] = NULL;
						}
						
					}
					
					// column 9
					for (int i = 104; i < 115; i++)
					{
						if (i > 104)
						{
							f[i].neighbour[0] = &f[i-1];
							f[i].neighbour[1] = &f[i+10];
							
						}
						else
						{
							f[i].neighbour[0] = NULL;
							f[i].neighbour[1] = NULL;
							
						}
						
						f[i].neighbour[5] = &f[i-11];
						
						
						if (i < 114)
						{
							f[i].neighbour[2] = &f[i+11];
							f[i].neighbour[3] = &f[i+1];
							f[i].neighbour[4] = &f[i-10];
						}
						else
						{
							f[i].neighbour[2] = NULL;
							f[i].neighbour[3] = NULL;
							f[i].neighbour[4] = NULL;
						}
						
					}
					
					// column 10
					for (int i = 115; i < 125; i++)
					{
						f[i].neighbour[1] = NULL;
						f[i].neighbour[2] = NULL;
						f[i].neighbour[4] = &f[i-10];
						f[i].neighbour[5] = &f[i-11];
						
						
						
						if (i > 115)
						{
							f[i].neighbour[0] = &f[i-1];
						}
						else
						{
							f[i].neighbour[0] = NULL;
						}
						
						if (i < 124)
						{
							f[i].neighbour[3] = &f[i+1];
						}
						else
						{
							f[i].neighbour[3] = NULL;
						}
						
					}
					
					
	
}

void cell::test_move(cell *start)
{
    char key;
	do
	{
	    key = readkey();
		start->type = 1;
		start->draw(screen);
		switch(key)
		{
		    case '2' :
			    if (start->neighbour[0])
				    start = start->neighbour[0];
				break;
			case 'w' :
			    if (start->neighbour[1])
				    start = start->neighbour[1];
				break;
			case 's' :
			    if (start->neighbour[2])
				    start = start->neighbour[2];
				break;
			case 'z' :
			    if (start->neighbour[3])
				    start = start->neighbour[3];
				break;
			case 'a' :
			    if (start->neighbour[4])
				    start = start->neighbour[4];
				break;
			case 'q' :
			    if (start->neighbour[5])
				    start = start->neighbour[5];
				break;
		}
		start->type = 2;
		start->draw(screen);
	}
	while (key != 27);
}
	
void cell::draw(BITMAP *where)
{
    if (type)
    {
        switch (flag)
        {
            case 0 :
 	            draw_trans_sprite(where, (BITMAP*)mydata[gem01 + type - 1].dat, x, y);
 	            break;
 	        case 1 :
                draw_trans_sprite(where, (BITMAP*)mydata[explo01 + rand()%8].dat, x, y);
                break;
            case 2 :
                draw_trans_sprite(where, (BITMAP*)mydata[explo11 + rand()%4].dat, x, y);
                break;
        }
             
    }
}

int do_game(void)
{
    // reset score counter
    totscore = 0;
    
    // do other initialising stuff
    
    
    // Each play_level call is one level that ends when required number
    // of stones is collected before time. Game ends if time runs out.

    // Parameters:
    // level number, stones to collect, time to use, number of different stones,
    // points per unused seconds, bonus seconds per ring, level completion points
    myfile.open("games.txt", std::ios::app);
	if (g.music_vol > 5)
        play_looped_midi((MIDI*)mydata[music1].dat, 33, 241);
    
    if
       ( // The following lines actually create the complete game
         // and all levels
        play_level( 1,  20, 120, 4, 100, 10, 1000, "Easy one") && // original
        //play_level( 1,  60, 120, 7, 100, 10, 1000, "Test") && // test level
        play_level( 2,  30, 125, 5, 100, 20, 1500, "") &&
        play_level( 3,  40, 130, 5, 200, 20, 2000, "") &&
        play_level( 4,  50, 135, 6, 200, 30, 2500, "") &&
        play_level( 5,  60, 140, 6, 300, 30, 3000, "") &&
        play_level( 6,  70, 145, 7, 300, 40, 3500, "Spectrolite is Wild") &&
        play_level( 7,  80, 150, 8, 400, 40, 4000, "What to do with blacks?") &&
        play_level( 8,  90, 160, 9, 400, 50, 4500, "White pops black") &&
        play_level( 9, 70, 160, 9, 500, 50, 5000, "") &&
        play_level(10, 80, 160, 9, 600, 60, 5500, "") &&
        play_level(11, 90, 160, 9, 700, 70, 6000, "") &&
        play_level(12, 100, 160, 9, 800, 80, 6500, "") && // probably too hard
        play_level(13, 100, 150, 9, 900, 90, 6500, "") && // probably too hard
        play_level(14, 100, 130, 9, 1000, 100, 6500, "") && // probably too hard
        play_level(15, 100, 110, 9, 1500, 120, 6500, "") && // probably too hard
        play_level(16, 100, 90, 9, 2000, 150, 6500, "") // probably too hard
        
       );
	stop_midi();
	myfile << "End of game!\n\n";
    myfile.close(); 
/* test runs
   5 levels 66912 pts
   9   168638
   
   
   
*/
    
}

bool play_level(int level, int stones_left, int time_left, int stone_collection,
                int pp_second, int bsp_ring, int lc_points, char *level_text)
{
//enum game_status
//{
//    game_on,
//    game_complete,
//    timeout,
//    full_field,
//    escape
//};
    myfile << "Level " << level << std::endl;
    
	game_status status;
    char text[256], text2[256], text3[256];
	sprintf(text, "Prepare for level %d", level);
	sprintf(text2, "%d different stones", stone_collection);
	myalert(text, text2, level_text, "", "Ok", 0, 0);
    cell *f;
	cell::empty(field);
	
	status = game_on;

	blit((BITMAP*)mydata[backgr1].dat, screen, 0, 0, 0, 0, 640, 480);	
	f = cell::start(field, stone_collection);
	tcount = 800;
	int swapper, tehkey=0, drop_speed;
	bool moved;
	drop_speed = NORMAL_DROP;
	seccount = time_left;
	set_palette((RGB*)mydata[bigfontpal].dat);
	print_score();
	do
	{   // Game loop here
		//textprintf_ex(screen, font, 1, 1, makecol(0, 0, 0), makecol(255, 255, 255), "%d", tcount);
        moved = false;
		if (keypressed())
		{
		    tehkey = readkey() >> 8;
		    moved = true;
//			switch (tehkey)
//			{
			    if (tehkey == g.left_key)
			    {
		            tcount = drop_speed;
			        if (cell::move_left(f))
			            f = f->neighbour[4];
                }
				if (tehkey == g.right_key)
				{
				    tcount = drop_speed;
			        if (cell::move_right(f))
			            f = f->neighbour[2];
                }
				if (tehkey == g.rotate_key)
				{
				    swapper = f->type;
					f->type = f->neighbour[0]->neighbour[0]->type;
					f->neighbour[0]->neighbour[0]->type = f->neighbour[0]->type;
					f->neighbour[0]->type = swapper;
                }
				if (tehkey == g.down_key)
				{
				    drop_speed = FAST_DROP;
				    tcount -= 600;
				    //clear_keybuf();
                }
				if (tehkey == KEY_ESC)
				{
				    status = escape;
				    //clear_keybuf();
                }
			
					
		}
		print_time();
		if (tcount < 0)
		{
		    if (cell::move_down(f))
			    f = f->neighbour[3];
			else
			{/* Check rings and triplets. Rings are worth more so check
			    first all rings, until no more rings can be found.
			    Then check one time for triplets, then do it again.
			 */
			    drop_speed = NORMAL_DROP;
			    int n;
                do
			    {
			        while (n=cell::check_rings(field) > 0)
				    {
					    if (n == 1)
					    {
                            stones_left -= 7;
                            totscore += 42;
                        }
                        if (n == 2)
                        {
                            stones_left -= 12;
                            totscore += 132;
                        }
                            
                        seccount += n * bsp_ring;
                        if (n > 3)
                            totscore += (n * (n-1));
                        //cell::draw_all(screen, field);
					    //rest(800);
				    }
				    n = cell::check_triplets(field);
				    stones_left -= n;
				    if (n > 3)
				        totscore += n * (n-1);
                }
                while (n > 0);
                if (stones_left <= 0)
                {
                    status = game_complete;
                    stones_left = 0;
                }
                print_stones(stones_left);
                print_score();
            
			
			
			// new triplet
			    if (status == game_on)
                    f = cell::start(field, stone_collection);
				if (!f)
				    status = full_field;
            }
			moved = true;	
			
			tcount += drop_speed;
		}
		if (moved)
		    cell::draw_all(screen, field);
		//rest(800);
                if (seccount <= 0)
                {
                    status = timeout;
                }
        if (breakdown)
            status = total_breakdown;
	}
	while (status == game_on);
	print_time();
	myfile << "Points at end: " << totscore << std::endl;
	stop_sample((SAMPLE*)mydata[ticktack].dat);
    
	if (status == game_complete)
	{
	    play_sample((SAMPLE*)mydata[level_completed].dat, SFX_VOL/2, 128, 1000, 0);
        totscore += pp_second * seccount;
	    sprintf(text, "Level %d completed!", level);
	    sprintf(text2, "Level points: %d", lc_points);
	    sprintf(text3, "Time bonus: %d", pp_second * seccount);
        myalert(text, text2, text3, "", "Ok", 0, 0);
	    totscore += lc_points;
    
	    return true;
    }
    
    if (status == timeout)
	{
        play_sample((SAMPLE*)mydata[zerotime].dat, SFX_VOL, 128, 1000, 0);
        stop_midi();
        sprintf(text, "You're out of time!");
        myfile << "You're out of time!" << std::endl;
        if (level == 2)
            sprintf(text2, "You completed %d level", level-1);
        else
            sprintf(text2, "You completed %d levels", level-1);
        sprintf(text3, "You scored %d points", totscore);
	    myalert(text, text2, text3, "", "Ok", 0, 0);
	    return false;
    }
    
    if (status == full_field)
	{
        play_sample((SAMPLE*)mydata[zerotime].dat, SFX_VOL, 128, 1000, 0);
        stop_midi();
        sprintf(text, "You got stucked!");
        myfile << "You got stucked!" << std::endl;
        if (level == 2)
            sprintf(text2, "You completed %d level", level-1);
        else
            sprintf(text2, "You completed %d levels", level-1);
	    sprintf(text3, "You scored %d points", totscore);
	    myalert(text, text2, text3, "", "Ok", 0, 0);
	    return false;
    }
    
    if (status == escape)
	{
        stop_midi();
        sprintf(text, "Game aborted!");
	    myfile << "Game aborted!" << std::endl;
        myalert(text, "", "", "", "Ok", 0, 0);
	    return false;
    }
    
    if (status == total_breakdown)
        return false;
    
    
}    

void do_settings(void)
{
    settings_menu();
}

void do_help(void)
{
    help_menu();
}

void do_scores(void)
{
    font = (FONT*)mydata[smallfont].dat;
    set_palette((RGB*)mydata[smallfontpal].dat);
    alert("Not implemented yet.", "", "", "Ok", NULL, -1, -1);
}

void do_extras(void)
{
    font = (FONT*)mydata[smallfont].dat;
    set_palette((RGB*)mydata[smallfontpal].dat);
    alert("Not implemented yet.", "", "", "Ok", NULL, -1, -1);
    
}

