#include <allegro.h>
#include "menus.h"
#include "data.h"

extern DATAFILE *mydata;

   
int d_mytextbox_proc(int msg, DIALOG *d, int c)
{
        FONT *old;
        RGB *oldpal;
        oldpal = new RGB[256];
        int res;
        old = font;
        font = (FONT*)mydata[smallfont].dat;
        get_palette(oldpal);
        set_palette((RGB*)mydata[smallfontpal].dat);
        res = d_ctext_proc(msg, d, c);
        font = old;
        set_palette(oldpal);
        delete [] oldpal;
        return res;
}

int d_mybutton_proc(int msg, DIALOG *d, int c)
{
        FONT *old;
        RGB *oldpal;
        oldpal = new RGB[256];
        int res;
        old = font;
        font = (FONT*)d->dp2;
        get_palette(oldpal);
        set_palette((RGB*)d->dp3);
        res = d_button_proc(msg, d, c);
        font = old;
        set_palette(oldpal);
        delete [] oldpal;
        return res;
}

int d_mybitmap_proc(int msg, DIALOG *d, int c)
{
    if (msg == MSG_DRAW)
    {
        set_alpha_blender();
        draw_trans_sprite(screen, (BITMAP*)d->dp, d->x, d->y);
        return D_O_K;
    }
    
    return d_bitmap_proc(msg, d, c);
}

int d_mybox_proc(int msg, DIALOG *d, int c)
{
    if (msg == MSG_DRAW)
    {
        rectfill(screen, d->x, d->y, d->x + d->w - 1, d->y + d->h - 1,
                 d->fg);
        int hicol, locol, r, g, b, r2, g2, b2;
        r = r2 = getr(d->fg);
        g = g2 = getg(d->fg);
        b = b2 = getb(d->fg);
        r = r + (255 - r) / 2;
        g = g + (255 - g) / 2;
        b = b + (255 - b) / 2;
        hicol = makecol(r, g, b);
        locol = makecol(r2/2, g2/2, b2/2);
        hline(screen, d->x, d->y, d->x + d->w - 1, hicol);
        hline(screen, d->x+3, d->y+d->h-3, d->x + d->w-3, hicol);
        vline(screen, d->x, d->y, d->y + d->h-1, hicol);
        vline(screen, d->x + d->w - 3, d->y + 3, d->y + d->h - 3, hicol);


        hline(screen, d->x+2, d->y+2, d->x + d->w - 4, locol);
        hline(screen, d->x+1, d->y+d->h-1, d->x + d->w-1, locol);
        vline(screen, d->x + 2, d->y + 2, d->y + d->h-4, locol);
        vline(screen, d->x + d->w - 1, d->y, d->y + d->h - 1, locol);
    }
    return D_O_K;
}



//int d_myicon_proc(int msg, DIALOG *d, int c)
//{
//    static BITMAP *b1;
//    static char *saver;
//    static myicon *mi;
//    int hr;
//    
//    switch (msg)
//    {
//        case MSG_START :
//            mi = new myicon((BITMAP*)d->dp2, d);
//            return d_icon_proc(msg, d, c);
//
//        case MSG_END :
//            delete mi;
//            return d_icon_proc(msg, d, c);
//            
//        default :
//            return d_icon_proc(msg, d, c);
//    }
//}

            
            
int d_dummy_proc(int msg, DIALOG *d, int c)
{
    return D_O_K;
}

myicon::~myicon()
{
    destroy_bitmap(bm1);
    destroy_bitmap(bm0);
    destroy_bitmap(bmx);
    
}

myicon::myicon(BITMAP *pat, char *txt, int x, int y)
{
    bm1 = create_bitmap(x, y);
    bm0 = create_bitmap(x, y);
    bmx = create_bitmap(x, y);
    int x0, y0;
    x0 = -(rand() % 20);
    y0 = -(rand() % 15);
    for (int i = y0; i < y; i += pat->h)
        for (int j = x0; j < x; j += pat->w)
        {
            blit(pat, bm1, 0, 0, j, i, pat->w, pat->h);
            blit(pat, bm0, 0, 0, j+1, i+1, pat->w, pat->h);
            blit(pat, bmx, 0, 0, j, i, pat->w, pat->h);
        }
    
    for (int i = 0; i < 4; i ++)
    {
        for (int j = i; j < x-i; j ++)
        {
            change_value(bm1, j, i, 3-i);
            change_value(bm1, j, y-i-1, -3+i);
            if (i < 3) change_value(bm0, j, i, -2);
            else change_value(bm0, j, i, -1);
        }
        for (int j = i+1; j < x-i-1; j ++)
        {
            change_value(bm1, i, j, 3-i);
            change_value(bm1, x-i-1, j, -3+i);
            if (i < 3) change_value(bm0, i, j, -2);
            else change_value(bm0, i, j, -1);

        }
    }
    
    textout_centre_ex(bm1, font, txt, x / 2, 5, -1, -1);
    textout_centre_ex(bm0, font, txt, x / 2+1, 5+1, -1, -1);
    textout_centre_ex(bmx, font, txt, x / 2, 5, -1, -1);
    
    for (int i = 0; i < x; i++)
        for (int j = 0; j < y; j++)
            change_contrast(bmx, i, j, 0.5);
}

void myicon::change_contrast(BITMAP *bm, int x, int y, float rat)
{
    int col, r, g, b;
    float h, s, v;
    col = getpixel(bm, x, y);
    r = getr(col);
    g = getg(col);
    b = getb(col);
    rgb_to_hsv(r, g, b, &h, &s, &v);
    
    v -= 0.5;
    v *= rat;
    v += 0.5;
    if (v > 1) v = 1;
    if (v < 0) v = 0;

    hsv_to_rgb(h, s, v, &r, &g, &b);
    col = makecol(r, g, b);
    putpixel(bm, x, y, col);
}



void myicon::change_value(BITMAP *bm, int x, int y, int val)
{
    int col, r, g, b;
    float h, s, v;
    col = getpixel(bm, x, y);
    r = getr(col);
    g = getg(col);
    b = getb(col);
    rgb_to_hsv(r, g, b, &h, &s, &v);
    if (val >= 0)
        v = v + (1 - v) * float(val)/5.;
    else
        v = v * float(5 + val) / 5.;
    hsv_to_rgb(h, s, v, &r, &g, &b);
    col = makecol(r, g, b);
    putpixel(bm, x, y, col);
}
    
int d_myfill_proc(int msg, DIALOG *d, int c)
{
    int old_state, oldx1, oldy1, oldx2, oldy2;
    BITMAP *pat = (BITMAP*)d->dp;
    
    int x0, y0, i, j;
    if (msg == MSG_DRAW)
    {
        old_state = get_clip_state(screen);
        get_clip_rect(screen, &oldx1, &oldy1, &oldx2, &oldy2);
        set_clip_rect(screen, d->x, d->y, d->x + d->w - 1, d->y + d->h - 1);
        set_clip_state(screen, 1);
         
        x0 = -(rand() % 20);
        y0 = -(rand() % 15);
        for (i = y0; i < d->h; i += pat->h)
            for (j = x0; j < d->w; j += pat->w)
                blit(pat, screen, 0, 0, d->x + j, d->y + i, pat->w, pat->h);
        set_clip_rect(screen, oldx1, oldy1, oldx2, oldy2);
        set_clip_state(screen, old_state);
    }
    return D_O_K;
}

int d_keysetting_proc(int msg, DIALOG *d, int c)
{
    int col, hicol, locol;
    switch(msg)
    {
        case MSG_DRAW :
            if (d->flags & D_GOTFOCUS)
            {
                col = makecol(240, 240, 240);
                hicol = makecol(255, 245, 255);
                locol = makecol(240, 180, 180);
            }
            else
            {
                col = makecol(220, 220, 220);
                hicol = makecol(245, 245, 245);
                locol = makecol(200, 200, 200);
            }
            rectfill(screen, d->x, d->y, d->x+d->w, d->y+d->h, col);
            hline(screen, d->x, d->y, d->x+d->w-1, locol);
            hline(screen, d->x+1, d->y+d->h, d->x+d->w, hicol);
            vline(screen, d->x, d->y, d->y+d->h-1, locol);
            vline(screen, d->x+d->w, d->y+1, d->y+d->h, hicol);
            
            set_palette((RGB*)mydata[minifontpal].dat);
            textout_centre_ex(screen, (FONT*)mydata[minifont].dat,
                       scancode_to_name(d->d1), d->x + d->w / 2, d->y+5, -1, -1);//scancode_to_name(d->d1)
            return D_O_K;
        case MSG_CHAR :
            d->d1 = c >> 8;
            //return D_REDRAWME;
            d->flags |= D_DIRTY;
            return D_USED_CHAR;
        case MSG_WANTFOCUS :
            if (mouse_b)
                return D_WANTFOCUS;
            else
                return D_O_K;
        case MSG_LOSTFOCUS :
            return D_WANTFOCUS;
        default :
            return D_O_K;
    }
}

