#ifndef CLASSESH
#define CLASSESH

#include <allegro.h>

#define NORMAL_DROP     800
#define FAST_DROP       1

struct globals
{
    int sfx_vol;
    int music_vol;
    int left_key;
    int right_key;
    int rotate_key;
    int down_key;
};

void print_time(void);
void print_score(void);
void print_stones(int stones);

bool play_level(int level, int stones_left, int time_left, int stone_collection,
                int pp_second, int bsp_ring, int lc_points, char *level_text);
int do_game(void);
void do_settings(void);
void do_help(void);
void do_scores(void);
void do_extras(void);
void my_total_breakdown(void);
enum game_status
{
    game_on,
    game_complete,
    timeout,
    full_field,
    total_breakdown,
    escape
};


class cell
{
	char flag;
	
    public:
    cell *neighbour[6];
	int type;
	int x, y;
	static void create_field(cell *f);
	void draw(BITMAP *where);
    static void test_move(cell *start);
	static void draw_all(BITMAP *where, cell *f);
	static int move_down(cell *f);
	static int move_left(cell *f);
	static int move_right(cell *f);
	static int check_triplets(cell *f);
	static int check_rings(cell *f);
	void check_ring(void);
	static void drop_down(cell *f);
	static void check_triplet(cell *f, int neighb);
	static void set_flag(cell *f, int n);
	static cell *start(cell *f, int sc);
	static void empty(cell *f);
	static bool flagged;
	static int howmany;
	static bool flag_blacks;
	static int next1, next2, next3;
};

#endif
